
uniform sampler2D shadowtex1;
uniform sampler2D shadowcolor0;
uniform sampler2D shadowcolor1;

const int shadowMapResolution = 2048;  // Shadowmap resolution [1024 2048 4096 8192 16384 32768]

vec3 WorldToShadowProjPos(in vec3 worldPos) {
	vec4 shadowPosition = shadowModelView * vec4(worldPos, 1.0);	//Transform from world space to shadow space
	shadowPosition = shadowProjection * shadowPosition;

	vec3 shadowPos = shadowPosition.xyz / shadowPosition.w;

	return shadowPos * 0.5f + 0.5f;		//Transform from shadow space to shadow map coordinates
}

vec2 DistortShadowSpace(in vec2 position) {
	position = position * 2.0 - 1.0;

	float dist = length(position.xy);
	float distortFactor = oneMinus(SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
	position *= 0.95f / distortFactor;

	return position * 0.5 + 0.5;
}

vec3 CalculateRSM(in vec3 viewPos, in vec3 worldNormal, in float dither) {
	vec3 total = vec3(0.0);

	const float realShadowMapRes = shadowMapResolution * MC_SHADOW_QUALITY;
	vec3 worldPos = mat3(gbufferModelViewInverse) * viewPos + gbufferModelViewInverse[3].xyz;
	vec3 shadowPos = WorldToShadowProjPos(worldPos);

	vec3 shadowNormal = mat3(shadowModelView) * worldNormal;
	shadowNormal.z = -shadowNormal.z;

	const float scale = GI_RADIUS * rcp(realShadowMapRes);
	const float rRadius = 1.0 / GI_RADIUS;
	//const float radiusAdd = GI_RADIUS / GI_SAMPLES;
	const float rSteps = 1.0 / GI_SAMPLES;

	//float skyLightmap = texelFetch(colortex0, ivec2(gl_FragCoord.xy * 2), 0).g;
	const float goldenAngle = TAU / (phi1 + 1.0);
	const mat2 goldenRotate = mat2(cos(goldenAngle), -sin(goldenAngle), sin(goldenAngle), cos(goldenAngle));

	vec2 rot = sincos(dither * 64.0/*  * goldenAngle */);

	for (uint i = 0u; i < GI_SAMPLES; ++i) {
		float fi 					= float(i) + dither;
		vec2 offset 				= rot * fi * rSteps;
		rot 						*= goldenRotate;

		//if (dot(shadowNormal.xy, offset) < 1e-5) offset = -offset;

		vec2 coord 					= shadowPos.xy + offset * scale;
		ivec2 sampleCoord 			= ivec2(DistortShadowSpace(coord) * realShadowMapRes);

		float sampleDepth 			= texelFetch(shadowtex1, sampleCoord, 0).x * 5.0 - 3.0;

		vec3 sampleVector 			= vec3(coord, sampleDepth) - shadowPos;
		if (sampleVector.z < 0.0) 	continue;

		//float sampleDist 	 = dotSelf(sampleVector);
		//if (sampleDist > GI_RADIUS * GI_RADIUS) continue;

		float sampleDist 			= length(sampleVector);
		if (sampleDist > GI_RADIUS) continue;

		//float falloff 	 		= rcp(sampleDist + radiusAdd);

		vec3 sampleDir 				= normalize(sampleVector);

		float diffuse 				= saturate(dot(shadowNormal, sampleDir));
		if (diffuse < 1e-5) 		continue;

		vec3 sampleColor 			= texelFetch(shadowcolor1, sampleCoord, 0).rgb;

		vec3 sampleNormal 			= DecodeNormal(sampleColor.xy);
		sampleNormal.xy 			= -sampleNormal.xy;

		float bounce 				= saturate(dot(sampleNormal, sampleDir));				
		if (bounce < 1e-5) 			continue;

		float falloff 				= rcp(sqr(sampleDist * rPI * rPI) + rRadius) * rcp(sampleDist + 1.0);

		#if defined IS_OVERWORLD
			//float skylightWeight = isEyeInWater == 1 ? 0.3 : saturate(1.0 - abs(sampleColor.z * 2.0 - 1.0 - skyLightmap) * 5.0);
			float skylightWeight 	= isEyeInWater == 1 ? 0.3 : saturate(sampleColor.z * 2.0 - 1.0);
		#else
			float skylightWeight 	= isEyeInWater == 1 ? 0.3 : 1.0;
		#endif

		vec3 albedo 				= SRGBtoLinear(texelFetch(shadowcolor0, sampleCoord, 0).rgb);

		total += albedo * falloff * skylightWeight * bounce * diffuse;
	}

	return total * rSteps * rTAU;	
}
