/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.ninni.species.criterion.SpeciesCriterion;
import com.ninni.species.entity.ai.LimpetAi;
import com.ninni.species.entity.enums.LimpetType;
import com.ninni.species.sound.SpeciesSoundEvents;
import com.ninni.species.tag.SpeciesTags;
import java.util.Arrays;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class LimpetEntity
extends class_1588 {
    protected static final ImmutableList<class_4149<? extends class_4148<? super LimpetEntity>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_18469);
    protected static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_39408, (Object)class_4140.field_22357);
    private static final class_2940<Integer> SCARED_TICKS = class_2945.method_12791(LimpetEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TYPE = class_2945.method_12791(LimpetEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> CRACKED_STAGE = class_2945.method_12791(LimpetEntity.class, (class_2941)class_2943.field_13327);
    private static final class_6019 RETREAT_DURATION = class_4802.method_24505((int)5, (int)20);

    protected LimpetEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected class_4095.class_5303<LimpetEntity> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    public class_4095<LimpetEntity> method_18868() {
        return super.method_18868();
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return LimpetAi.makeBrain((class_4095<LimpetEntity>)this.method_28306().method_28335(dynamic));
    }

    public float method_49476() {
        return 1.0f;
    }

    @Nullable
    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        int i = this.chooseLimpetType((class_1936)serverLevelAccessor);
        if (spawnGroupData instanceof LimpetGroupData) {
            i = ((LimpetGroupData)spawnGroupData).limpetType;
        } else {
            spawnGroupData = new LimpetGroupData(i);
        }
        this.setLimpetType(i);
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public int chooseLimpetType(class_1936 world) {
        class_6880 holder = world.method_23753(this.method_24515());
        int yLevel = this.method_24515().method_10264();
        if (yLevel > 20) {
            if (holder.method_40220(ConventionalBiomeTags.MOUNTAIN)) {
                return LimpetType.EMERALD.getId();
            }
            if (this.field_5974.method_43048(5) == 0) {
                return LimpetType.LAPIS.getId();
            }
            return LimpetType.COAL.getId();
        }
        if (yLevel < 20 && yLevel > -20) {
            return LimpetType.AMETHYST.getId();
        }
        if (yLevel <= -20) {
            if (this.field_5974.method_43048(5) == 0) {
                return LimpetType.DIAMOND.getId();
            }
            return LimpetType.COAL.getId();
        }
        return LimpetType.SHELL.getId();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("limpetBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("limpetActivityUpdate");
        LimpetAi.updateActivity(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public static class_5132.class_5133 createLimpetAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SCARED_TICKS, (Object)0);
        this.field_6011.method_12784(TYPE, (Object)0);
        this.field_6011.method_12784(CRACKED_STAGE, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("ScaredTicks", this.getScaredTicks());
        nbt.method_10569("LimpetType", this.getLimpetType().getId());
        nbt.method_10569("CrackedStage", this.getCrackedStage());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setScaredTicks(nbt.method_10550("ScaredTicks"));
        this.setLimpetType(nbt.method_10550("LimpetType"));
        this.setCrackedStage(nbt.method_10550("CrackedStage"));
    }

    public int getCrackedStage() {
        return (Integer)this.field_6011.method_12789(CRACKED_STAGE);
    }

    public void setCrackedStage(int crackedStage) {
        this.field_6011.method_12778(CRACKED_STAGE, (Object)crackedStage);
    }

    public LimpetType getLimpetType() {
        return LimpetType.TYPES[(Integer)this.field_6011.method_12789(TYPE)];
    }

    public void setLimpetType(int id) {
        this.field_6011.method_12778(TYPE, (Object)id);
    }

    public int getScaredTicks() {
        return (Integer)this.field_6011.method_12789(SCARED_TICKS);
    }

    public void setScaredTicks(int scaredTicks) {
        this.field_6011.method_12778(SCARED_TICKS, (Object)scaredTicks);
    }

    public boolean isScared() {
        return this.getScaredTicks() > 0;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            if (!this.method_18868().method_18896(class_4140.field_22357)) {
                this.method_37908().method_8390(class_1657.class, this.method_5829().method_1014(4.0), this::isValidEntity).forEach(player -> this.setScaredTicks(100));
            }
            if (this.getScaredTicks() > 0) {
                int scaredTicks = this.method_18868().method_18896(class_4140.field_22357) ? 0 : this.getScaredTicks() - 1;
                this.method_5942().method_6340();
                this.setScaredTicks(scaredTicks);
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        LimpetType type = this.getLimpetType();
        class_1799 stack = player.method_5998(interactionHand);
        if (this.getCrackedStage() > 0 && type.getId() > 0 && stack.method_7909() == type.getItem() && !this.method_18868().method_18896(class_4140.field_22357)) {
            this.setCrackedStage(this.getCrackedStage() - 1);
            this.method_5783(type.getPlacingSound(), 1.0f, 1.0f);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.method_5971();
            return class_1269.field_5812;
        }
        return super.method_5992(player, interactionHand);
    }

    public boolean method_5810() {
        return !this.isScared();
    }

    public boolean isValidEntity(class_1657 player) {
        Optional<class_1799> stack = this.getStackInHand(player);
        return this.getLimpetType().getId() > 0 && !player.method_7325() && player.method_5805() && !player.method_31549().field_7477 && !player.method_5715() || this.getLimpetType().getId() > 0 && stack.isPresent() && stack.get().method_7909() instanceof class_1810;
    }

    public boolean isValidEntityHoldingPickaxe(class_1657 player) {
        return this.getLimpetType().getId() > 0 && this.getStackInHand(player).isPresent() && this.getStackInHand(player).get().method_7909() instanceof class_1810;
    }

    public Optional<class_1799> getStackInHand(class_1657 player) {
        return Arrays.stream(class_1268.values()).filter(hand -> player.method_5998(hand).method_7909() instanceof class_1810).map(arg_0 -> ((class_1657)player).method_5998(arg_0)).findFirst();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean method_5643(class_1282 source, float amount) {
        LimpetType type = this.getLimpetType();
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1810 pickaxe;
            class_1657 player = (class_1657)class_12972;
            if (type.getId() > 0 && this.getStackInHand(player).isPresent() && (class_12972 = this.getStackInHand(player).get().method_7909()) instanceof class_1810 && (pickaxe = (class_1810)class_12972).method_8022().method_8024() >= type.getPickaxeLevel() && !player.method_7357().method_7904((class_1792)pickaxe)) {
                if (type.getId() > 1 && !this.method_37908().method_8608()) {
                    this.spawnBreakingParticles();
                }
                class_1799 stack = this.getStackInHand(player).get();
                if (this.getCrackedStage() < 3) {
                    this.method_18868().method_24525(class_4140.field_22357, (Object)player, (long)RETREAT_DURATION.method_35008(this.method_37908().field_9229));
                    this.setCrackedStage(this.getCrackedStage() + 1);
                    this.method_5783(type.getMiningSound(), 1.0f, 1.0f);
                    this.setScaredTicks(0);
                    player.method_7357().method_7906(stack.method_7909(), 80);
                    return false;
                }
                this.method_5870((class_1935)type.getItem(), 1);
                if (this.field_5974.method_43048(2) == 1) {
                    this.method_5870((class_1935)type.getItem(), 1);
                }
                switch (class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stack)) {
                    case 1: {
                        if (this.field_5974.method_43048(4) == 1) {
                            this.method_5870((class_1935)type.getItem(), 1);
                        }
                    }
                    case 2: {
                        if (this.field_5974.method_43048(2) == 1) {
                            this.method_5870((class_1935)type.getItem(), 1);
                        }
                    }
                    case 3: {
                        this.method_5870((class_1935)type.getItem(), 1);
                        break;
                    }
                }
                this.setCrackedStage(0);
                this.method_5783(type.getMiningSound(), 1.0f, 1.0f);
                if (class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) != 0) {
                    this.setLimpetType(1);
                    if (!(player instanceof class_3222)) return false;
                    SpeciesCriterion.SILK_TOUCH_BREAK_LIMPET.trigger((class_3222)player);
                    return false;
                }
                this.setLimpetType(0);
                this.setScaredTicks(0);
                return super.method_5643(source, amount);
            }
        }
        if (!(source.method_5529() instanceof class_1309)) return super.method_5643(source, amount);
        if (!(amount < 12.0f)) return super.method_5643(source, amount);
        if (this.method_37908().field_9236) return super.method_5643(source, amount);
        if (type.getId() <= 0) return super.method_5643(source, amount);
        this.method_5783(SpeciesSoundEvents.ENTITY_LIMPET_DEFLECT, 1.0f, 1.0f);
        if (this.method_18868().method_18896(class_4140.field_22357)) return false;
        this.setScaredTicks(300);
        return false;
    }

    private void spawnBreakingParticles() {
        class_243 vec3 = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.5, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * 0.5f);
        ((class_3218)this.method_37908()).method_14199((class_2394)new class_2392(class_2398.field_11218, this.getLimpetType().getItem().method_7854()), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 60, vec3.field_1352 + (double)this.field_5974.method_43051(-10, 10) * 0.5, vec3.field_1351 + (double)this.field_5974.method_43051(0, 10) * 0.1, vec3.field_1350 - (double)this.field_5974.method_43051(-10, 10) * 0.5, 0.0);
    }

    public void method_6091(class_243 vec3) {
        if (!this.method_18868().method_18896(class_4140.field_22357) && this.isScared()) {
            this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            vec3 = vec3.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(vec3);
    }

    @Nullable
    protected class_3414 method_5994() {
        return SpeciesSoundEvents.ENTITY_LIMPET_IDLE;
    }

    protected class_3414 method_6002() {
        return SpeciesSoundEvents.ENTITY_LIMPET_DEATH;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return SpeciesSoundEvents.ENTITY_LIMPET_HURT;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(SpeciesSoundEvents.ENTITY_LIMPET_STEP, 0.15f, 1.0f);
    }

    public static boolean canSpawn(class_1299<? extends class_1588> type, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8317(pos) == 0 && world.method_8320(pos.method_10074()).method_26164(SpeciesTags.LIMPET_SPAWNABLE_ON);
    }

    public static class LimpetGroupData
    implements class_1315 {
        public final int limpetType;

        public LimpetGroupData(int i) {
            this.limpetType = i;
        }
    }
}

