/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.block.entity;

import com.google.common.collect.Lists;
import com.ninni.species.block.BirtDwellingBlock;
import com.ninni.species.block.entity.SpeciesBlockEntities;
import com.ninni.species.entity.BirtEntity;
import com.ninni.species.sound.SpeciesSoundEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class BirtDwellingBlockEntity
extends class_2586 {
    public static final String MIN_OCCUPATION_TICKS_KEY = "MinOccupationTicks";
    public static final String ENTITY_DATA_KEY = "EntityData";
    public static final String TICKS_IN_DWELLING_KEY = "TicksInDwelling";
    public static final String BIRTS_KEY = "Birts";
    private static final List<String> IRRELEVANT_BIRT_NBT_KEYS = Arrays.asList("Air", "Bees", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "CannotEnterDwellingTicks", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "DwellingPos", "HivePos", "Passengers", "Leash", "UUID");
    private final List<Birt> birts = Lists.newArrayList();
    private int day = -1;

    public BirtDwellingBlockEntity(class_2338 pos, class_2680 state) {
        super(SpeciesBlockEntities.BIRT_DWELLING, pos, state);
    }

    public boolean hasNoBirts() {
        return this.birts.isEmpty();
    }

    public boolean isFullOfBirts() {
        return this.birts.size() == 3;
    }

    public void angerBirts(@Nullable class_1657 player, class_2680 state, BirtState birtState) {
        List<class_1297> list = this.tryReleaseBirt(state, birtState);
        if (player != null) {
            for (class_1297 entity : list) {
                if (!(entity instanceof BirtEntity)) continue;
                BirtEntity birt = (BirtEntity)entity;
                if (!(player.method_19538().method_1025(entity.method_19538()) <= 16.0)) continue;
                birt.method_5980((class_1309)player);
                birt.setCannotEnterDwellingTicks(400);
            }
        }
    }

    public static void tickLayEgg(BirtDwellingBlockEntity birtDwellingBlockEntity, class_1937 world, class_2338 blockPos, class_2680 state) {
        long day = world.method_8532() / 24000L;
        if (birtDwellingBlockEntity.day == -1 || day != (long)birtDwellingBlockEntity.day && day == 0L) {
            birtDwellingBlockEntity.day = (int)day;
        }
        if ((Integer)state.method_11654((class_2769)BirtDwellingBlock.BIRTS) > 0 && (long)birtDwellingBlockEntity.day < day) {
            ++birtDwellingBlockEntity.day;
            world.method_8501(blockPos, (class_2680)state.method_11657((class_2769)BirtDwellingBlock.EGGS, (Comparable)Integer.valueOf(Math.min(5, (Integer)state.method_11654((class_2769)BirtDwellingBlock.EGGS) + (Integer)state.method_11654((class_2769)BirtDwellingBlock.BIRTS)))));
        }
    }

    private List<class_1297> tryReleaseBirt(class_2680 state, BirtState birtState) {
        ArrayList list = Lists.newArrayList();
        this.birts.removeIf(birt -> {
            assert (this.field_11863 != null);
            return BirtDwellingBlockEntity.releaseBirt(this.field_11863, this.field_11867, state, birt, list, birtState);
        });
        if (!list.isEmpty()) {
            super.method_5431();
        }
        return list;
    }

    public void tryEnterDwelling(class_1297 entity) {
        this.tryEnterDwelling(entity, 0);
    }

    public void tryEnterDwelling(class_1297 entity, int ticksInDwelling) {
        if (this.birts.size() >= 3) {
            return;
        }
        entity.method_5848();
        entity.method_5772();
        class_2487 nbtCompound = new class_2487();
        entity.method_5662(nbtCompound);
        class_2338 blockPos = this.method_11016();
        this.addBirt(nbtCompound, ticksInDwelling);
        if (this.field_11863 != null) {
            this.field_11863.method_43128(null, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), SpeciesSoundEvents.BLOCK_BIRT_DWELLING_ENTER, class_3419.field_15245, 1.0f, 1.0f);
            this.field_11863.method_43276(class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)this.method_11010()));
        }
        entity.method_31472();
        super.method_5431();
    }

    public void addBirt(class_2487 nbtCompound, int ticksInDwelling) {
        assert (this.field_11863 != null);
        this.birts.add(new Birt(nbtCompound, ticksInDwelling, 1200));
    }

    private static boolean releaseBirt(class_1937 world, class_2338 pos, class_2680 state, Birt birt, @Nullable List<class_1297> entities, BirtState birtState) {
        boolean bl;
        if ((world.method_23886() || world.method_8419()) && birtState != BirtState.EMERGENCY) {
            return false;
        }
        class_2487 nbtCompound = birt.entityData.method_10553();
        BirtDwellingBlockEntity.removeIrrelevantNbtKeys(nbtCompound);
        nbtCompound.method_10566("DwellingPos", (class_2520)class_2512.method_10692((class_2338)pos));
        class_2350 direction = (class_2350)state.method_11654((class_2769)BirtDwellingBlock.FACING);
        class_2338 blockPos = pos.method_10093(direction);
        boolean bl2 = bl = !world.method_8320(blockPos).method_26220((class_1922)world, blockPos).method_1110();
        if (bl && birtState != BirtState.EMERGENCY) {
            return false;
        }
        class_1297 newBirt = class_1299.method_17842((class_2487)nbtCompound, (class_1937)world, entity -> entity);
        if (newBirt != null) {
            if (newBirt instanceof BirtEntity) {
                BirtEntity birtEntity = (BirtEntity)newBirt;
                BirtDwellingBlockEntity.ageBirt(Birt.ticksInDwelling, birtEntity);
                if (entities != null) {
                    entities.add((class_1297)birtEntity);
                }
            } else {
                return false;
            }
            float f = newBirt.method_17681();
            double d = bl ? 0.0 : 0.55 + (double)(f / 2.0f);
            double x = (double)pos.method_10263() + 0.5 + d * (double)direction.method_10148();
            double y = (double)pos.method_10264() + 0.5 - (double)(newBirt.method_17682() / 2.0f);
            double z = (double)pos.method_10260() + 0.5 + d * (double)direction.method_10165();
            newBirt.method_5808(x, y, z, newBirt.method_36454(), newBirt.method_36455());
            world.method_8396(null, pos, SpeciesSoundEvents.BLOCK_BIRT_DWELLING_EXIT, class_3419.field_15245, 1.0f, 1.0f);
            world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)newBirt, (class_2680)world.method_8320(pos)));
            return world.method_8649(newBirt);
        }
        return false;
    }

    static void removeIrrelevantNbtKeys(class_2487 compound) {
        for (String string : IRRELEVANT_BIRT_NBT_KEYS) {
            compound.method_10551(string);
        }
    }

    private static void ageBirt(int ticks, BirtEntity birt) {
        int i = birt.method_5618();
        if (i < 0) {
            birt.method_5614(Math.min(0, i + ticks));
        } else if (i > 0) {
            birt.method_5614(Math.max(0, i - ticks));
        }
    }

    private static void tickBirts(class_1937 world, class_2338 pos, class_2680 state, List<Birt> birts) {
        boolean bl = false;
        Iterator<Birt> iterator = birts.iterator();
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)BirtDwellingBlock.BIRTS, (Comparable)Integer.valueOf(birts.size())));
        while (iterator.hasNext()) {
            Birt birt = iterator.next();
            if (Birt.ticksInDwelling > birt.minOccupationTicks && BirtDwellingBlockEntity.releaseBirt(world, pos, state, birt, null, BirtState.BIRT_RELEASED)) {
                bl = true;
                iterator.remove();
            }
            ++Birt.ticksInDwelling;
        }
        if (bl) {
            BirtDwellingBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, BirtDwellingBlockEntity blockEntity) {
        BirtDwellingBlockEntity.tickBirts(world, pos, state, blockEntity.birts);
        BirtDwellingBlockEntity.tickLayEgg(blockEntity, world, pos, state);
        if (!blockEntity.birts.isEmpty() && world.method_8409().method_43058() < 0.005) {
            double d = (double)pos.method_10263() + 0.5;
            double e = pos.method_10264();
            double f = (double)pos.method_10260() + 0.5;
            world.method_43128(null, d, e, f, SpeciesSoundEvents.BLOCK_BIRT_DWELLING_WORK, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.birts.clear();
        class_2499 nbtList = nbt.method_10554(BIRTS_KEY, 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            Birt birt = new Birt(nbtCompound.method_10562(ENTITY_DATA_KEY), nbtCompound.method_10550(TICKS_IN_DWELLING_KEY), nbtCompound.method_10550(MIN_OCCUPATION_TICKS_KEY));
            this.birts.add(birt);
        }
        this.day = nbt.method_10550("Day");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566(BIRTS_KEY, (class_2520)this.getBirts());
        nbt.method_10569("Day", this.day);
    }

    public class_2499 getBirts() {
        class_2499 nbtList = new class_2499();
        for (Birt birt : this.birts) {
            class_2487 nbtCompound = birt.entityData.method_10553();
            nbtCompound.method_10551("UUID");
            class_2487 nbtCompound2 = new class_2487();
            nbtCompound2.method_10566(ENTITY_DATA_KEY, (class_2520)nbtCompound);
            nbtCompound2.method_10569(IRRELEVANT_BIRT_NBT_KEYS.toString(), Birt.ticksInDwelling);
            nbtCompound2.method_10569(MIN_OCCUPATION_TICKS_KEY, birt.minOccupationTicks);
            nbtList.add((Object)nbtCompound2);
        }
        return nbtList;
    }

    public static enum BirtState {
        BIRT_RELEASED,
        EMERGENCY;

    }

    static class Birt {
        final class_2487 entityData;
        static int ticksInDwelling;
        final int minOccupationTicks;

        Birt(class_2487 entityData, int ticksInDwelling, int minOccupationTicks) {
            BirtDwellingBlockEntity.removeIrrelevantNbtKeys(entityData);
            this.entityData = entityData;
            Birt.ticksInDwelling = ticksInDwelling;
            this.minOccupationTicks = minOccupationTicks;
        }
    }
}

