/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldream.mythicmobs.entity;

import java.util.Arrays;
import java.util.List;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animatable.instance.SingletonAnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_3738;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import net.pixeldream.mythicmobs.config.MythicMobsConfigs;
import net.pixeldream.mythicmobs.entity.MushroomVariant;
import net.pixeldream.mythicmobs.entity.constant.DefaultAnimations;
import org.jetbrains.annotations.Nullable;

public class MushroomEntity
extends class_1314
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final RawAnimation BOUNCE = RawAnimation.begin().thenPlay("bounce");
    protected static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(MushroomEntity.class, (class_2941)class_2943.field_13327);
    private class_2561 currentLine;
    private List<String> lines;
    private List<String> greetings;
    private int lineCooldown = 60;
    private boolean touched = false;
    private boolean startCountdown = false;
    private boolean talk = true;
    private class_3414 interactSound;

    public MushroomEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 1;
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, MythicMobsConfigs.mushroomHealth).method_26868(class_5134.field_23719, 0.3);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        MushroomVariant variant = (MushroomVariant)((Object)class_156.method_27173((Object[])MushroomVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public MushroomVariant getVariant() {
        return MushroomVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(MushroomVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_10550("Variant"));
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, (double)0.8f));
        this.field_6201.method_6277(2, (class_1352)new class_1379((class_1314)this, 0.75));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    public void method_5773() {
        super.method_5773();
        if (this.startCountdown) {
            --this.lineCooldown;
            if (this.lineCooldown <= 0) {
                this.startCountdown = false;
                this.talk = true;
                this.lineCooldown = 60;
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 3, state -> {
            if (state.isMoving()) {
                state.getController().setAnimation(DefaultAnimations.WALK);
                return PlayState.CONTINUE;
            }
            state.getController().setAnimation(DefaultAnimations.IDLE);
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "bounceController", 3, state -> {
            if (this.touched) {
                state.getController().forceAnimationReset();
                state.getController().setAnimation(BOUNCE);
                this.touched = false;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.getVariant().equals((Object)MushroomVariant.RED)) {
            this.interactSound = class_3417.field_14815;
            this.lines = MythicMobsConfigs.redMushroomLines;
            this.greetings = Arrays.asList("Hello there, ", "Hey there, ", "Howdy, ", "Howdy-do, ", "Salutations, ", "Hiya, ", "Godspeed, ");
        } else {
            this.interactSound = class_3417.field_15008;
            this.lines = MythicMobsConfigs.brownMushroomLines;
        }
        this.currentLine = class_2561.method_43470((String)this.lines.get(this.field_5974.method_43048(this.lines.size())));
        if (this.talk) {
            this.touched = true;
            this.talk = false;
            this.startCountdown = true;
            class_2561 previousLine = this.currentLine;
            do {
                this.currentLine = class_2561.method_43470((String)this.lines.get(this.field_5974.method_43048(this.lines.size())));
                if (!this.currentLine.equals((Object)class_2561.method_43470((String)"playerGreeting"))) continue;
                this.currentLine = class_2561.method_43470((String)(this.greetings.get(this.field_5974.method_43048(this.greetings.size())) + player.method_5820() + "!"));
            } while (this.currentLine.equals((Object)previousLine));
            MinecraftServer server = player.method_5682();
            if (server != null) {
                this.method_5783(this.interactSound, 1.0f, 15.0f);
                server.method_18858((Runnable)new class_3738(0, () -> player.method_7353(this.currentLine, true)));
            }
        }
        return super.method_5992(player, hand);
    }

    protected void produceParticles(class_2394 parameters) {
        for (int i = 0; i < 5; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406(parameters, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f);
        }
    }

    public void method_6108() {
        ++this.field_6213;
        if (this.field_6213 == 15) {
            if (this.getVariant().equals((Object)MushroomVariant.RED)) {
                this.method_5775(new class_1799((class_1935)class_1802.field_17517));
            } else {
                this.method_5775(new class_1799((class_1935)class_1802.field_17516));
            }
            this.method_5650(class_1297.class_5529.field_26998);
            this.method_23883();
        }
    }

    public void method_6078(class_1282 damageSource) {
        this.produceParticles((class_2394)class_2398.field_11203);
        super.method_6078(damageSource);
    }

    protected class_3414 method_5994() {
        this.method_5783(class_3417.field_15175, 1.0f, 15.0f);
        return null;
    }

    protected class_3414 method_6011(class_1282 source) {
        this.method_5783(class_3417.field_15139, 1.0f, 15.0f);
        return null;
    }

    protected class_3414 method_6002() {
        this.method_5783(class_3417.field_15225, 1.0f, 15.0f);
        return null;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14772, 0.25f, 15.0f);
    }
}

