/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.handler;

import crystalspider.harvestwithease.api.HarvestWithEaseAPI;
import crystalspider.harvestwithease.api.event.HarvestWithEaseEvents;
import crystalspider.harvestwithease.config.ModConfig;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UseBlockHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"harvestwithease");

    public static class_1269 handle(class_1657 player, class_1937 world, class_1268 hand, class_3965 result) {
        class_1269 actionResult = class_1269.field_5811;
        if (!player.method_7325()) {
            class_2338 blockPos = result.method_17777();
            class_2680 blockState = world.method_8320(blockPos);
            if (hand == UseBlockHandler.getInteractionHand(player) && UseBlockHandler.canHarvest(world, blockState, blockPos, player, hand, true)) {
                try {
                    class_2758 cropAge = HarvestWithEaseAPI.getAge(blockState);
                    if (HarvestWithEaseAPI.isMature(blockState, cropAge)) {
                        actionResult = class_1269.field_5812;
                        if (!world.method_8608()) {
                            class_1831 tool;
                            UseBlockHandler.harvest((class_3218)world, cropAge, blockState, blockPos, result.method_17780(), result, (class_3222)player, hand);
                            class_1792 class_17922 = player.method_5998(hand).method_7909();
                            if (class_17922 instanceof class_1831 && UseBlockHandler.isHoe((tool = (class_1831)class_17922).method_7854()) && HarvestWithEaseAPI.isTierForMultiHarvest(tool)) {
                                int fromCenterToEdge = ((HarvestWithEaseAPI.getTierLevel(tool.method_8022()) - HarvestWithEaseAPI.getTierLevel(ModConfig.getMultiHarvestStartingTier())) * ModConfig.getAreaIncrementStep().step + ModConfig.getAreaStartingSize().size - 1) / 2;
                                class_2338.method_23627((class_3341)UseBlockHandler.expandHorizontally(new class_3341(blockPos), fromCenterToEdge)).filter(pos -> !pos.equals((Object)blockPos)).forEach(pos -> {
                                    class_2758 age;
                                    class_2680 state = world.method_8320(pos);
                                    if (UseBlockHandler.canHarvest(world, state, pos, player, hand, false) && HarvestWithEaseAPI.isMature(state, age = HarvestWithEaseAPI.getAge(state))) {
                                        UseBlockHandler.harvest((class_3218)world, age, state, pos, result.method_17780(), null, (class_3222)player, hand);
                                    }
                                });
                            }
                        }
                    }
                }
                catch (ClassCastException | NullPointerException | NoSuchElementException e) {
                    LOGGER.debug("Exception generated by block at [" + blockPos.method_23854() + "]");
                    LOGGER.debug("This is a non blocking error, but can result in incorrect behavior for mod harvestwithease");
                    LOGGER.debug("Most probably the cause of this issue was that a non-crop ID was added in the configuration and its age property could not be retrieved, see stack trace for more details", (Throwable)e);
                }
            }
        }
        return actionResult;
    }

    private static void harvest(class_3218 world, class_2758 age, class_2680 blockState, class_2338 blockPos, class_2350 face, class_3965 hitResult, class_3222 player, class_1268 hand) {
        ((HarvestWithEaseEvents.BeforeHarvest)HarvestWithEaseEvents.BEFORE_HARVEST.invoker()).beforeHarvest(world, blockState, blockPos, face, hitResult, player, hand, hitResult != null);
        class_2338 basePos = UseBlockHandler.getBasePos(world, blockState.method_26204(), blockPos);
        UseBlockHandler.grantExp(world, basePos);
        UseBlockHandler.damageHoe(player, hand);
        UseBlockHandler.updateCrop(world, age, blockState.method_26204(), basePos, player, UseBlockHandler.dropResources(world, world.method_8320(basePos), basePos, face, hitResult, player, hand));
        UseBlockHandler.playSound(world, blockState, blockPos);
        ((HarvestWithEaseEvents.AfterHarvest)HarvestWithEaseEvents.AFTER_HARVEST.invoker()).afterHarvest(world, blockState, blockPos, face, hitResult, player, hand, hitResult != null);
    }

    private static void updateCrop(class_3218 world, class_2758 age, class_2248 block, class_2338 basePos, class_3222 player, boolean customDrops) {
        world.method_8501(basePos, block == class_2246.field_43228 ? class_2246.field_10124.method_9564() : (class_2680)world.method_8320(basePos).method_11657((class_2769)age, (Comparable)Integer.valueOf(0)));
        if (world.method_8320(basePos).method_26164(class_3481.field_20341) && world.method_8320(basePos.method_10084()).method_27852(block) && !UseBlockHandler.isTallButSeparate(block)) {
            world.method_8651(basePos.method_10084(), !customDrops, (class_1297)player);
        }
    }

    private static class_2338 getBasePos(class_3218 world, class_2248 block, class_2338 blockPos) {
        class_2338 basePos = blockPos;
        while (world.method_8320(blockPos).method_26164(class_3481.field_20341) && !UseBlockHandler.isTallButSeparate(block) && world.method_8320(basePos.method_10074()).method_27852(block)) {
            basePos = basePos.method_10074();
        }
        return basePos;
    }

    private static void grantExp(class_3218 world, class_2338 pos) {
        if (ModConfig.getGrantedExp() > 0 && world.method_8450().method_8355(class_1928.field_19392)) {
            class_1303.method_31493((class_3218)world, (class_243)class_243.method_24953((class_2382)pos), (int)ModConfig.getGrantedExp());
        }
    }

    private static void damageHoe(class_3222 player, class_1268 hand) {
        if (ModConfig.getRequireHoe().booleanValue() && ModConfig.getDamageOnHarvest() > 0 && !player.method_7337()) {
            player.method_5998(hand).method_7956(ModConfig.getDamageOnHarvest().intValue(), (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
        }
    }

    private static boolean dropResources(class_3218 world, class_2680 blockState, class_2338 blockPos, class_2350 face, class_3965 hitResult, class_3222 player, class_1268 hand) {
        HarvestWithEaseEvents.HarvestDropsEvent event = new HarvestWithEaseEvents.HarvestDropsEvent(world, blockState, blockPos, player, hand);
        for (class_1799 stack : ((HarvestWithEaseEvents.HarvestDrops)HarvestWithEaseEvents.HARVEST_DROPS.invoker()).getDrops(world, blockState, blockPos, face, hitResult, player, hand, hitResult != null, event)) {
            if (blockState.method_26220((class_1922)world, blockPos) != class_259.method_1073()) {
                class_2248.method_36992((class_1937)world, (class_2338)blockPos, (class_2350)face, (class_1799)stack);
                continue;
            }
            class_2248.method_9577((class_1937)world, (class_2338)blockPos, (class_1799)stack);
        }
        return event.haveDropsChanged();
    }

    private static void playSound(class_3218 world, class_2680 blockState, class_2338 blockPos) {
        if (ModConfig.getPlaySound().booleanValue()) {
            class_2498 soundGroup = blockState.method_26204().method_9573(blockState);
            world.method_8396(null, blockPos, soundGroup.method_10595(), class_3419.field_15245, soundGroup.method_10597(), soundGroup.method_10599());
        }
    }

    @Nullable
    private static class_1268 getInteractionHand(class_1657 player) {
        if (!player.method_5715()) {
            if (UseBlockHandler.isHoe(player.method_5998(class_1268.field_5808))) {
                return class_1268.field_5808;
            }
            if (UseBlockHandler.isHoe(player.method_5998(class_1268.field_5810))) {
                return class_1268.field_5810;
            }
            if (!ModConfig.getRequireHoe().booleanValue()) {
                return class_1268.field_5808;
            }
        }
        return null;
    }

    private static boolean isHoe(class_1799 handItem) {
        return handItem.method_7909() instanceof class_1794;
    }

    private static boolean canHarvest(class_1937 world, class_2680 blockState, class_2338 blockPos, class_1657 player, class_1268 hand, boolean first) {
        return HarvestWithEaseAPI.isCrop(blockState.method_26204()) && player.method_7305(blockState) && ((HarvestWithEaseEvents.HarvestCheck)HarvestWithEaseEvents.HARVEST_CHECK.invoker()).check(world, blockState, blockPos, player, hand, first, new HarvestWithEaseEvents.HarvestCheckEvent());
    }

    private static boolean isTallButSeparate(class_2248 block) {
        Optional key = class_7923.field_41175.method_29113((Object)block);
        if (key.isPresent()) {
            return ((class_5321)key.get()).method_29177().toString().equals("farmersdelight:tomatoes");
        }
        return false;
    }

    private static class_3341 expandHorizontally(class_3341 box, int distance) {
        return new class_3341(box.method_35415() - distance, box.method_35416(), box.method_35417() - distance, box.method_35418() + distance, box.method_35419(), box.method_35420() + distance);
    }
}

