/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.mixin;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.mixed.JsonUnbakedModelMixed;
import io.github.lucaargolo.seasons.utils.Season;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1088;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4730;
import net.minecraft.class_793;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1088.class})
public class ModelLoaderMixin {
    @Inject(at={@At(value="RETURN")}, method={"loadModelFromJson"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void injectSeasonalModels(class_2960 id, CallbackInfoReturnable<class_793> cir) {
        class_310 client = class_310.method_1551();
        Optional optional = client.method_1478().method_14486(new class_2960(id.method_12836(), "seasons/models/" + id.method_12832() + ".json"));
        if (optional.isPresent()) {
            class_3298 resource = (class_3298)optional.get();
            try {
                JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8)).getAsJsonObject();
                if (json.has("textures")) {
                    JsonObject textures = json.getAsJsonObject("textures");
                    JsonUnbakedModelMixed model = (JsonUnbakedModelMixed)cir.getReturnValue();
                    model.setSeasonalTextureMap(new HashMap<Season, Map<String, Either<class_4730, String>>>());
                    for (Season s : Season.values()) {
                        String code = s.name().toLowerCase(Locale.ROOT);
                        if (!textures.has(code)) continue;
                        HashMap map = Maps.newHashMap();
                        JsonObject jsonObject = textures.getAsJsonObject(code);
                        for (Map.Entry entry : jsonObject.entrySet()) {
                            map.put((String)entry.getKey(), class_793.class_795.method_24079((class_2960)class_1723.field_21668, (String)((JsonElement)entry.getValue()).getAsString()));
                        }
                        model.getSeasonalTextureMap().put(s, map);
                    }
                }
            }
            catch (Exception e) {
                FabricSeasons.LOGGER.error("[Fabric Seasons] Failed loading season texture variants for " + id, (Throwable)e);
            }
        }
    }
}

