/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.lmd.config;

import com.frikinjay.lmd.LetMeDespawn;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class LetMeDespawnConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private Set<String> mobNames = new HashSet<String>();

    public Set<String> getMobNames() {
        return this.mobNames;
    }

    public void addMobName(String mobName) {
        this.mobNames.add(mobName);
        this.save();
    }

    public void removeMobName(String mobName) {
        this.mobNames.remove(mobName);
        this.save();
    }

    public static LetMeDespawnConfig load() {
        if (LetMeDespawn.CONFIG_FILE.exists()) {
            LetMeDespawnConfig letMeDespawnConfig;
            FileReader reader = new FileReader(LetMeDespawn.CONFIG_FILE);
            try {
                letMeDespawnConfig = (LetMeDespawnConfig)GSON.fromJson((Reader)reader, LetMeDespawnConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | IOException e) {
                    LetMeDespawn.logger.log(Level.SEVERE, "Failed to load LetMeDespawn config", e);
                }
            }
            reader.close();
            return letMeDespawnConfig;
        }
        return new LetMeDespawnConfig();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(LetMeDespawn.CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            LetMeDespawn.logger.log(Level.SEVERE, "Failed to save LetMeDespawn config", e);
        }
    }

    public static void createDefaultConfig() {
        LetMeDespawnConfig config = new LetMeDespawnConfig();
        config.save();
    }
}

