/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.palette.slant;

import com.dfsek.terra.addons.chunkgenerator.generation.math.samplers.Sampler3D;
import com.dfsek.terra.addons.chunkgenerator.palette.slant.SlantHolder;

public abstract class SlantHolderImpl
implements SlantHolder {
    private final SlantHolder.CalculationMethod calculationMethod;
    private final int slantDepth;
    protected final boolean floorToThreshold;

    protected SlantHolderImpl(int slantDepth, SlantHolder.CalculationMethod calculationMethod) {
        this.floorToThreshold = calculationMethod.floorToThreshold();
        this.calculationMethod = calculationMethod;
        this.slantDepth = slantDepth;
    }

    protected abstract double getSlantThreshold();

    @Override
    public final double calculateSlant(Sampler3D sampler, double x, double y, double z) {
        return this.calculationMethod.slant(sampler, x, y, z);
    }

    @Override
    public final boolean isAboveDepth(int depth) {
        return depth <= this.slantDepth;
    }

    @Override
    public final boolean isInSlantThreshold(double slant) {
        return this.floorToThreshold ? slant > this.getSlantThreshold() : slant < this.getSlantThreshold();
    }
}

