/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.palette.slant;

import com.dfsek.terra.addons.chunkgenerator.palette.PaletteHolder;
import com.dfsek.terra.addons.chunkgenerator.palette.slant.SlantHolder;
import com.dfsek.terra.addons.chunkgenerator.palette.slant.SlantHolderImpl;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultipleSlantHolder
extends SlantHolderImpl {
    private final NavigableMap<Double, PaletteHolder> layers;
    private final double slantThreshold;

    MultipleSlantHolder(List<SlantHolder.Layer> slant, int slantDepth, SlantHolder.CalculationMethod calculationMethod) {
        super(slantDepth, calculationMethod);
        TreeMap<Double, PaletteHolder> layers = new TreeMap<Double, PaletteHolder>(slant.stream().collect(Collectors.toMap(SlantHolder.Layer::threshold, SlantHolder.Layer::palette)));
        Stream thresholds = layers.keySet().stream();
        double slantThreshold = this.floorToThreshold ? (Double)thresholds.min(Double::compare).orElseThrow() : (Double)thresholds.max(Double::compare).orElseThrow();
        this.layers = layers;
        this.slantThreshold = slantThreshold;
    }

    @Override
    protected double getSlantThreshold() {
        return this.slantThreshold;
    }

    @Override
    public PaletteHolder getPalette(double slant) {
        return (this.floorToThreshold ? this.layers.floorEntry(slant) : this.layers.ceilingEntry(slant)).getValue();
    }
}

