/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.generation.math.interpolation;

import com.dfsek.terra.addons.chunkgenerator.config.noise.BiomeNoiseProperties;
import com.dfsek.terra.addons.chunkgenerator.generation.math.interpolation.Interpolator3;
import com.dfsek.terra.addons.chunkgenerator.lib.jafama.FastMath;
import com.dfsek.terra.api.properties.PropertyKey;
import com.dfsek.terra.api.util.Column;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;

public class ChunkInterpolator {
    private final Interpolator3[][][] interpGrid;
    private final int min;
    private final int max;

    public ChunkInterpolator(long seed, int chunkX, int chunkZ, BiomeProvider provider, int min, int max, PropertyKey<BiomeNoiseProperties> noisePropertiesKey, int maxBlend) {
        int x;
        this.min = min;
        this.max = max;
        int xOrigin = chunkX << 4;
        int zOrigin = chunkZ << 4;
        int range = this.max - this.min + 1;
        int size = range >> 2;
        this.interpGrid = new Interpolator3[4][size][4];
        double[][][] noiseStorage = new double[5][5][size + 1];
        int maxBlendAndChunk = 17 + 2 * maxBlend;
        Column[] columns = new Column[maxBlendAndChunk * maxBlendAndChunk];
        for (x = 0; x < 5; ++x) {
            int scaledX = x << 2;
            int absoluteX = xOrigin + scaledX;
            for (int z = 0; z < 5; ++z) {
                int scaledZ = z << 2;
                int absoluteZ = zOrigin + scaledZ;
                int index = scaledX + maxBlend + maxBlendAndChunk * (scaledZ + maxBlend);
                Column biomeColumn = columns[index];
                if (biomeColumn == null) {
                    columns[index] = biomeColumn = provider.getColumn(absoluteX, absoluteZ, seed, min, max);
                }
                for (int y = 0; y < size; ++y) {
                    double noise;
                    int scaledY = (y << 2) + min;
                    BiomeNoiseProperties generationSettings = (BiomeNoiseProperties)((Biome)biomeColumn.get(scaledY)).getContext().get(noisePropertiesKey);
                    int step = generationSettings.blendStep();
                    int blend = generationSettings.blendDistance();
                    double runningNoise = 0.0;
                    double runningDiv = 0.0;
                    for (int xi = -blend; xi <= blend; ++xi) {
                        for (int zi = -blend; zi <= blend; ++zi) {
                            int blendX = xi * step;
                            int blendZ = zi * step;
                            int localIndex = scaledX + maxBlend + blendX + maxBlendAndChunk * (scaledZ + maxBlend + blendZ);
                            Column column = columns[localIndex];
                            if (column == null) {
                                columns[localIndex] = column = provider.getColumn(absoluteX + blendX, absoluteZ + blendZ, seed, min, max);
                            }
                            BiomeNoiseProperties properties = (BiomeNoiseProperties)((Biome)column.get(scaledY)).getContext().get(noisePropertiesKey);
                            double sample = properties.noiseHolder().getNoise(properties.base(), absoluteX, scaledY, absoluteZ, seed);
                            runningNoise += sample * properties.blendWeight();
                            runningDiv += properties.blendWeight();
                        }
                    }
                    noiseStorage[x][z][y] = noise = runningNoise / runningDiv;
                    if (y != size - 1) continue;
                    noiseStorage[x][z][size] = noise;
                }
            }
        }
        for (x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                for (int y = 0; y < size; ++y) {
                    this.interpGrid[x][y][z] = new Interpolator3(noiseStorage[x][z][y], noiseStorage[x + 1][z][y], noiseStorage[x][z][y + 1], noiseStorage[x + 1][z][y + 1], noiseStorage[x][z + 1][y], noiseStorage[x + 1][z + 1][y], noiseStorage[x][z + 1][y + 1], noiseStorage[x + 1][z + 1][y + 1]);
                }
            }
        }
    }

    private static int reRange(int value, int high) {
        return FastMath.max(FastMath.min(value, high), 0);
    }

    public double getNoise(double x, double y, double z) {
        return this.interpGrid[ChunkInterpolator.reRange((int)x / 4, 3)][(FastMath.max(FastMath.min((int)y, this.max), this.min) - this.min) / 4][ChunkInterpolator.reRange((int)z / 4, 3)].trilerp(x % 4.0 / 4.0, y % 4.0 / 4.0, z % 4.0 / 4.0);
    }

    public double getNoise(int x, int y, int z) {
        return this.interpGrid[x / 4][(y - this.min) / 4][z / 4].trilerp((double)(x & 3) / 4.0, (double)(y & 3) / 4.0, (double)(z & 3) / 4.0);
    }
}

