/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.generation;

import com.dfsek.terra.addons.chunkgenerator.config.noise.BiomeNoiseProperties;
import com.dfsek.terra.addons.chunkgenerator.generation.math.PaletteUtil;
import com.dfsek.terra.addons.chunkgenerator.generation.math.interpolation.LazilyEvaluatedInterpolator;
import com.dfsek.terra.addons.chunkgenerator.generation.math.samplers.Sampler3D;
import com.dfsek.terra.addons.chunkgenerator.generation.math.samplers.SamplerProvider;
import com.dfsek.terra.addons.chunkgenerator.lib.jafama.FastMath;
import com.dfsek.terra.addons.chunkgenerator.palette.BiomePaletteInfo;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.properties.PropertyKey;
import com.dfsek.terra.api.util.Column;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import com.dfsek.terra.api.world.chunk.generation.ChunkGenerator;
import com.dfsek.terra.api.world.chunk.generation.ProtoChunk;
import com.dfsek.terra.api.world.chunk.generation.util.Palette;
import com.dfsek.terra.api.world.info.WorldProperties;
import org.jetbrains.annotations.NotNull;

public class NoiseChunkGenerator3D
implements ChunkGenerator {
    private final Platform platform;
    private final SamplerProvider samplerCache;
    private final BlockState air;
    private final int carverHorizontalResolution;
    private final int carverVerticalResolution;
    private final PropertyKey<BiomePaletteInfo> paletteInfoPropertyKey;
    private final PropertyKey<BiomeNoiseProperties> noisePropertiesKey;

    public NoiseChunkGenerator3D(ConfigPack pack, Platform platform, int elevationBlend, int carverHorizontalResolution, int carverVerticalResolution, PropertyKey<BiomeNoiseProperties> noisePropertiesKey, PropertyKey<BiomePaletteInfo> paletteInfoPropertyKey) {
        this.platform = platform;
        this.air = platform.getWorldHandle().air();
        this.carverHorizontalResolution = carverHorizontalResolution;
        this.carverVerticalResolution = carverVerticalResolution;
        this.paletteInfoPropertyKey = paletteInfoPropertyKey;
        this.noisePropertiesKey = noisePropertiesKey;
        int maxBlend = pack.getBiomeProvider().stream().map(biome -> (BiomeNoiseProperties)biome.getContext().get(noisePropertiesKey)).mapToInt(properties -> properties.blendDistance() * properties.blendStep()).max().orElse(0);
        this.samplerCache = new SamplerProvider(platform, elevationBlend, noisePropertiesKey, maxBlend);
    }

    public void generateChunkData(@NotNull ProtoChunk chunk, @NotNull WorldProperties world, @NotNull BiomeProvider biomeProvider, int chunkX, int chunkZ) {
        this.platform.getProfiler().push("chunk_base_3d");
        int xOrig = chunkX << 4;
        int zOrig = chunkZ << 4;
        Sampler3D sampler = this.samplerCache.getChunk(chunkX, chunkZ, world, biomeProvider);
        long seed = world.getSeed();
        LazilyEvaluatedInterpolator carver = new LazilyEvaluatedInterpolator(biomeProvider, chunkX, chunkZ, world.getMaxHeight(), this.noisePropertiesKey, world.getMinHeight(), this.carverHorizontalResolution, this.carverVerticalResolution, seed);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int paletteLevel = 0;
                int cx = xOrig + x;
                int cz = zOrig + z;
                Column biomeColumn = biomeProvider.getColumn(cx, cz, world);
                for (int y = world.getMaxHeight() - 1; y >= world.getMinHeight(); --y) {
                    Biome biome = (Biome)biomeColumn.get(y);
                    BiomePaletteInfo paletteInfo = (BiomePaletteInfo)biome.getContext().get(this.paletteInfoPropertyKey);
                    int sea = paletteInfo.seaLevel();
                    Palette seaPalette = paletteInfo.ocean();
                    if (sampler.sample(x, y, z) > 0.0) {
                        if (carver.sample(x, y, z) <= 0.0) {
                            BlockState data = PaletteUtil.getPalette(x, y, z, sampler, paletteInfo, paletteLevel).get(paletteLevel, (double)cx, (double)y, (double)cz, seed);
                            chunk.setBlock(x, y, z, data);
                            ++paletteLevel;
                            continue;
                        }
                        if (paletteInfo.updatePaletteWhenCarving()) {
                            paletteLevel = 0;
                            continue;
                        }
                        ++paletteLevel;
                        continue;
                    }
                    if (y <= sea) {
                        chunk.setBlock(x, y, z, seaPalette.get(sea - y, (double)(x + xOrig), (double)y, (double)(z + zOrig), seed));
                        paletteLevel = 0;
                        continue;
                    }
                    paletteLevel = 0;
                }
            }
        }
        this.platform.getProfiler().pop("chunk_base_3d");
    }

    public BlockState getBlock(WorldProperties world, int x, int y, int z, BiomeProvider biomeProvider) {
        Biome biome = biomeProvider.getBiome(x, y, z, world.getSeed());
        Sampler3D sampler = this.samplerCache.get(x, z, world, biomeProvider);
        BiomePaletteInfo paletteInfo = (BiomePaletteInfo)biome.getContext().get(this.paletteInfoPropertyKey);
        int fdX = FastMath.floorMod(x, 16);
        int fdZ = FastMath.floorMod(z, 16);
        Palette palette = PaletteUtil.getPalette(fdX, y, fdZ, sampler, paletteInfo, 0);
        double noise = sampler.sample(fdX, y, fdZ);
        if (noise > 0.0) {
            int level = 0;
            for (int yi = world.getMaxHeight() - 1; yi > y; --yi) {
                if (sampler.sample(fdX, yi, fdZ) > 0.0) {
                    ++level;
                    continue;
                }
                level = 0;
            }
            return palette.get(level, (double)x, (double)y, (double)z, world.getSeed());
        }
        if (y <= paletteInfo.seaLevel()) {
            return paletteInfo.ocean().get(paletteInfo.seaLevel() - y, (double)x, (double)y, (double)z, world.getSeed());
        }
        return this.air;
    }

    public Palette getPalette(int x, int y, int z, WorldProperties world, BiomeProvider biomeProvider) {
        return ((BiomePaletteInfo)biomeProvider.getBiome(x, y, z, world.getSeed()).getContext().get(this.paletteInfoPropertyKey)).paletteHolder().getPalette(y);
    }

    public SamplerProvider samplerProvider() {
        return this.samplerCache;
    }
}

