/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.abridged.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.abridged.config.ConfigHandler;
import dev.worldgen.abridged.platform.Services;
import dev.worldgen.abridged.registry.AbridgedRegistries;
import dev.worldgen.abridged.worldgen.structure.BridgePieces;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3828;
import net.minecraft.class_4651;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5497;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6012;
import net.minecraft.class_6130;
import net.minecraft.class_6497;
import net.minecraft.class_6624;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6910;
import net.minecraft.class_7151;
import net.minecraft.class_7924;

public class BridgeStructure
extends class_3195 {
    public static final Codec<BridgeStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BridgeStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_6497.method_37953((Codec)Codec.INT).fieldOf("height").forGetter(BridgeStructure::height), (App)Codec.INT.fieldOf("max_height_difference").forGetter(BridgeStructure::maxHeightDifference), (App)class_5699.method_48766((int)1, (int)12).fieldOf("max_chunk_search_distance").forGetter(BridgeStructure::maxChunkSearchDistance), (App)Codec.DOUBLE.fieldOf("min_erosion").orElse((Object)Double.NEGATIVE_INFINITY).forGetter(BridgeStructure::minErosion), (App)Codec.DOUBLE.fieldOf("max_erosion").orElse((Object)Double.POSITIVE_INFINITY).forGetter(BridgeStructure::maxErosion), (App)class_6005.method_34972(TemplateData.CODEC).fieldOf("template_data_entries").forGetter(BridgeStructure::templateDataEntries), (App)ExtensionData.CODEC.listOf().fieldOf("extensions").forGetter(BridgeStructure::extensions)).apply((Applicative)instance, BridgeStructure::new));
    private final class_6497<Integer> height;
    private final Integer maxHeightDifference;
    private final Integer maxChunkSearchDistance;
    private final Double minErosion;
    private final Double maxErosion;
    private final class_6005<TemplateData> templateDataEntries;
    private final List<ExtensionData> extensions;

    protected BridgeStructure(class_3195.class_7302 config, class_6497<Integer> height, Integer maxHeightDifference, Integer maxChunkSearchDistance, Double minErosion, Double maxErosion, class_6005<TemplateData> templateDataEntries, List<ExtensionData> extensions) {
        super(config);
        this.height = height;
        this.maxHeightDifference = maxHeightDifference;
        this.maxChunkSearchDistance = maxChunkSearchDistance;
        this.minErosion = minErosion;
        this.maxErosion = maxErosion;
        this.templateDataEntries = templateDataEntries;
        this.extensions = extensions;
    }

    public class_6497<Integer> height() {
        return this.height;
    }

    public Integer maxHeightDifference() {
        return this.maxHeightDifference;
    }

    public Integer maxChunkSearchDistance() {
        return this.maxChunkSearchDistance;
    }

    public Double minErosion() {
        return this.minErosion;
    }

    public Double maxErosion() {
        return this.maxErosion;
    }

    public class_6005<TemplateData> templateDataEntries() {
        return this.templateDataEntries;
    }

    public List<ExtensionData> extensions() {
        return this.extensions;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        BridgeData bridgeData = this.getBridgeData(context);
        if (bridgeData == null) {
            return Optional.empty();
        }
        class_2338 pos = new class_2338(context.comp_568().method_33940(), bridgeData.getHeight().intValue(), context.comp_568().method_33942());
        Set nearbyBiomes = context.comp_563().method_8763(pos.method_10263(), pos.method_10264(), pos.method_10260(), this.maxChunkSearchDistance * 4, context.comp_564().method_42371());
        Optional<TemplateData> templateData = this.getRandomTemplateData(nearbyBiomes, (class_5819)context.comp_566());
        return templateData.flatMap(data -> BridgeStructure.method_41612((class_3195.class_7149)context, (class_2902.class_2903)class_2902.class_2903.field_13195, collector -> this.addPieces((class_6626)collector, context, pos, bridgeData, (TemplateData)data)));
    }

    private void addPieces(class_6626 collector, class_3195.class_7149 context, class_2338 pos, BridgeData bridgeData, TemplateData templateData) {
        BridgePieces.addPieces(context.comp_565(), pos, (class_6130)collector, bridgeData, templateData);
    }

    private BridgeData getBridgeData(class_3195.class_7149 context) {
        if (ConfigHandler.getConfig().frequency() != 1.0f && context.comp_566().method_43057() > ConfigHandler.getConfig().frequency()) {
            return null;
        }
        class_2338 pos = new class_2338(context.comp_568().method_33940(), 90, context.comp_568().method_33942());
        double erosion = context.comp_564().method_42370().comp_423().method_40464((class_6910.class_6912)new class_6910.class_6914(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        if (erosion < this.minErosion || erosion > this.maxErosion || BridgeStructure.getHeightmap(pos, context) > 60) {
            return null;
        }
        BridgeData xBridgeData = this.findValidSegmentLayout(context, pos, class_2350.field_11034);
        return xBridgeData != null ? xBridgeData : this.findValidSegmentLayout(context, pos, class_2350.field_11035);
    }

    private BridgeData findValidSegmentLayout(class_3195.class_7149 context, class_2338 pos, class_2350 direction) {
        List<Integer> leftHeights = this.buildHeightmapList(context, pos, direction.method_10153());
        List<Integer> rightHeights = this.buildHeightmapList(context, pos, direction);
        if (leftHeights == null || rightHeights == null) {
            return null;
        }
        Integer negativeHeight = null;
        Integer positiveHeight = null;
        Integer chunkOffset = null;
        Integer totalSegments = null;
        block0: for (int k = 0; k < leftHeights.size(); ++k) {
            Integer leftHeight = leftHeights.get(k);
            if (leftHeight == Integer.MIN_VALUE) continue;
            for (int l = 0; l < rightHeights.size(); ++l) {
                Integer rightHeight = rightHeights.get(l);
                if (rightHeight == Integer.MIN_VALUE || Math.abs(leftHeight - rightHeight) > this.maxHeightDifference) continue;
                negativeHeight = leftHeight;
                positiveHeight = rightHeight;
                chunkOffset = -k - 1;
                totalSegments = Math.abs(chunkOffset) + l + 1;
                break block0;
            }
        }
        if (negativeHeight == null) {
            return null;
        }
        return new BridgeData(negativeHeight, positiveHeight, chunkOffset, totalSegments, direction);
    }

    private List<Integer> buildHeightmapList(class_3195.class_7149 context, class_2338 pos, class_2350 direction) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        for (int j = 1; j <= this.maxChunkSearchDistance; ++j) {
            int height = BridgeStructure.getHeightmap(pos.method_10079(direction, 16 * j), context);
            if (j != 1 && (Integer)heights.get(heights.size() - 1) > height) break;
            if (this.height.method_37955((Comparable)Integer.valueOf(height))) {
                heights.add(height);
                continue;
            }
            heights.add(Integer.MIN_VALUE);
        }
        return heights.stream().noneMatch(value -> value != Integer.MIN_VALUE) ? null : heights;
    }

    private Optional<TemplateData> getRandomTemplateData(Set<class_6880<class_1959>> nearbyBiomes, class_5819 random) {
        class_6012 validEntries = class_6005.method_34988(this.templateDataEntries.method_34994().stream().filter(entry -> ((TemplateData)entry.method_34983()).isValid(nearbyBiomes)).toList());
        Optional templateCandidate = validEntries.method_34992(random);
        return templateCandidate.map(class_6008.class_6010::method_34983);
    }

    private static int getHeightmap(class_2338 pos, class_3195.class_7149 context) {
        return context.comp_562().method_20402(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13195, context.comp_569(), context.comp_564());
    }

    public void method_38694(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 box, class_1923 chunkPos, class_6624 pieces) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int i = world.method_31607();
        class_3341 blockBox = pieces.method_38712();
        int j = blockBox.method_35416();
        for (ExtensionData extension : this.extensions) {
            for (int k = box.method_35415(); k <= box.method_35418(); ++k) {
                block2: for (int l = box.method_35417(); l <= box.method_35420(); ++l) {
                    mutable.method_10103(k, j, l);
                    if (!world.method_8320((class_2338)mutable).method_40143(extension.blocks()) || world.method_22347((class_2338)mutable) || !blockBox.method_14662((class_2382)mutable) || !pieces.method_38710((class_2338)mutable)) continue;
                    for (int m = j - 1; m > i; --m) {
                        mutable.method_33098(m);
                        if (!world.method_22347((class_2338)mutable) && !world.method_8320((class_2338)mutable).method_51176() && !world.method_8320((class_2338)mutable).method_27852(class_2246.field_10219)) continue block2;
                        world.method_8652((class_2338)mutable, extension.extendedState().method_23455(random, (class_2338)mutable), 3);
                    }
                }
            }
        }
    }

    public class_7151<?> method_41618() {
        return AbridgedRegistries.BRIDGE_STRUCTURE;
    }

    public record BridgeData(Integer leftHeight, Integer rightHeight, Integer chunkOffset, Integer totalSegments, class_2350 direction) {
        public class_2470 getRotation() {
            return this.direction.method_10166() == class_2350.class_2351.field_11048 ? class_2470.field_11467 : class_2470.field_11463;
        }

        public Integer getHeight() {
            return Math.min(this.leftHeight, this.rightHeight);
        }
    }

    public record TemplateData(class_2960 base, class_2960 negativeEdge, class_2960 positiveEdge, class_6880<class_5497> processorList, class_6885<class_1959> biomes, Integer offset, List<String> requiredMods) {
        public static final Codec<TemplateData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("base").forGetter(TemplateData::base), (App)class_2960.field_25139.fieldOf("negative_edge").forGetter(TemplateData::negativeEdge), (App)class_2960.field_25139.fieldOf("positive_edge").forGetter(TemplateData::positiveEdge), (App)class_3828.field_25877.fieldOf("processors").forGetter(TemplateData::processorList), (App)class_1959.field_26750.fieldOf("biomes").forGetter(TemplateData::biomes), (App)Codec.INT.fieldOf("offset").orElse((Object)0).forGetter(TemplateData::offset), (App)Codec.STRING.listOf().fieldOf("required_mods").orElse(List.of()).forGetter(TemplateData::requiredMods)).apply((Applicative)instance, TemplateData::new));

        public class_2960 getProcessorId() {
            Optional key = this.processorList().method_40230();
            return key.map(class_5321::method_29177).orElseGet(() -> new class_2960("empty"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isValid(Set<class_6880<class_1959>> nearbyBiomes) {
            if (!nearbyBiomes.stream().anyMatch(arg_0 -> this.biomes.method_40241(arg_0))) return false;
            if (!this.requiredMods.stream().allMatch(Services.PLATFORM::isModLoaded)) return false;
            return true;
        }
    }

    public record ExtensionData(class_6885<class_2248> blocks, class_4651 extendedState) {
        public static final Codec<ExtensionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41254).fieldOf("blocks").orElse((Object)class_6885.method_40246((class_6880[])new class_6880[0])).forGetter(ExtensionData::blocks), (App)class_4651.field_24937.fieldOf("extended_state").forGetter(ExtensionData::extendedState)).apply((Applicative)instance, ExtensionData::new));
    }
}

