/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.abridged.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.worldgen.abridged.config.ConfigCodec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;

public class ConfigHandler {
    private static final ConfigCodec DEFAULT_CONFIG = new ConfigCodec(1.0f);
    private static ConfigCodec CONFIG;

    public static void load(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(gson.toJson((JsonElement)ConfigCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)DEFAULT_CONFIG).result().get()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonElement json = JsonParser.parseReader((Reader)reader);
            Optional<ConfigCodec> result = ConfigCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
            if (result.isEmpty()) {
                result = Optional.of(DEFAULT_CONFIG);
            }
            CONFIG = (ConfigCodec)result.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson((JsonElement)ConfigCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)CONFIG).result().get()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ConfigCodec getConfig() {
        return CONFIG;
    }
}

