/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.jmb19905.niftycarts.NiftyCarts;
import net.jmb19905.niftycarts.entity.AbstractDrawnEntity;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NiftyWorld
extends class_18 {
    private static NiftyWorld clientInstance = null;
    private final Int2ObjectMap<AbstractDrawnEntity> pulling = new Int2ObjectOpenHashMap();

    public void addPulling(AbstractDrawnEntity drawn) {
        @Nullable class_1297 pulling = drawn.getPulling();
        if (pulling != null) {
            this.pulling.put(pulling.method_5628(), (Object)drawn);
            this.method_80();
        }
    }

    public void setPulling(int pullId, AbstractDrawnEntity drawn) {
        this.pulling.put(pullId, (Object)drawn);
        this.method_80();
    }

    public Optional<AbstractDrawnEntity> getDrawn(class_1297 e) {
        if (e == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((AbstractDrawnEntity)((Object)this.pulling.get(e.method_5628())));
    }

    public boolean isPulling(class_1297 e) {
        return this.pulling.containsKey(e.method_5628());
    }

    public void tick() {
        IntIterator it = this.pulling.keySet().iterator();
        while (it.hasNext()) {
            int pullId = (Integer)it.next();
            AbstractDrawnEntity cart = (AbstractDrawnEntity)((Object)this.pulling.get(pullId));
            if (cart.shouldStopPulledTick()) {
                it.remove();
                this.method_80();
                continue;
            }
            if (cart.getPulling() instanceof AbstractDrawnEntity) continue;
            cart.pulledTick();
        }
    }

    public Int2ObjectMap<AbstractDrawnEntity> getPulling() {
        return this.pulling;
    }

    @NotNull
    public class_2487 method_75(class_2487 tag) {
        class_2499 drawnList = new class_2499();
        for (AbstractDrawnEntity drawn : this.pulling.values()) {
            drawnList.add((Object)class_2512.method_25929((UUID)drawn.method_5667()));
        }
        tag.method_10566("drawnList", (class_2520)drawnList);
        return tag;
    }

    public static NiftyWorld createFromNbt(class_2487 tag, class_3218 level) {
        NiftyWorld data = new NiftyWorld();
        class_2499 drawnList = tag.method_10554("drawnList", 11);
        for (class_2520 item : drawnList) {
            UUID uuid = class_2512.method_25930((class_2520)item);
            class_1297 class_12972 = level.method_14190(uuid);
            if (!(class_12972 instanceof AbstractDrawnEntity)) continue;
            AbstractDrawnEntity drawn = (AbstractDrawnEntity)class_12972;
            data.addPulling(drawn);
        }
        return data;
    }

    public static NiftyWorld get(class_1937 level) {
        if (level.method_8608()) {
            return NiftyWorld.getClient();
        }
        return NiftyWorld.getServer(NiftyCarts.server, (class_5321<class_1937>)level.method_27983());
    }

    public static NiftyWorld getClient() {
        if (clientInstance == null) {
            clientInstance = new NiftyWorld();
        }
        return clientInstance;
    }

    public static NiftyWorld getServer(MinecraftServer server, class_5321<class_1937> levelType) {
        class_26 dataStorage = Objects.requireNonNull(server.method_3847(levelType)).method_17983();
        return (NiftyWorld)dataStorage.method_17924(tag -> NiftyWorld.createFromNbt(tag, server.method_3847(levelType)), NiftyWorld::new, "niftycarts");
    }
}

