/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.client.renderer.entity.model.EasyMeshBuilder;
import net.jmb19905.niftycarts.entity.AbstractDrawnEntity;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5609;
import net.minecraft.class_583;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public abstract class CartModel<T extends AbstractDrawnEntity>
extends class_583<T> {
    protected final class_630 body;
    protected final class_630 leftWheel;
    protected final class_630 rightWheel;

    protected CartModel(class_630 root) {
        this.body = root.method_32086("body");
        this.leftWheel = root.method_32086("leftWheel");
        this.rightWheel = root.method_32086("rightWheel");
    }

    public class_630 getBody() {
        return this.body;
    }

    public class_630 getWheel() {
        return this.rightWheel;
    }

    public void method_2828(class_4587 stack, class_4588 buf, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.method_22699(stack, buf, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftWheel.method_22699(stack, buf, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightWheel.method_22699(stack, buf, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float delta, float limbSwingAmount, float ageInTicks, float netHeadYaw, float pitch) {
        float rot;
        this.body.field_3654 = (float)Math.toRadians(pitch);
        this.rightWheel.field_3654 = (float)(((AbstractDrawnEntity)((Object)entity)).getWheelRotation(0) + ((AbstractDrawnEntity)((Object)entity)).getWheelRotationIncrement(0) * (double)delta);
        this.leftWheel.field_3654 = (float)(((AbstractDrawnEntity)((Object)entity)).getWheelRotation(1) + ((AbstractDrawnEntity)((Object)entity)).getWheelRotationIncrement(1) * (double)delta);
        float time = (float)((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit() - delta;
        if (time > 0.0f) {
            float damage = Math.max(((AbstractDrawnEntity)((Object)entity)).getDamageTaken() - delta, 0.0f);
            rot = (float)Math.toRadians(class_3532.method_15374((float)time) * time * damage / 40.0f * (float)(-((AbstractDrawnEntity)((Object)entity)).getForwardDirection()));
        } else {
            rot = 0.0f;
        }
        this.rightWheel.field_3674 = rot;
        this.leftWheel.field_3674 = rot;
    }

    public static class_5609 createDefinition() {
        class_5609 def = new class_5609();
        EasyMeshBuilder leftWheel = new EasyMeshBuilder("leftWheel", 46, 60);
        leftWheel.setRotationPoint(14.5f, -11.0f, 1.0f);
        leftWheel.addBox(-2.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f);
        for (int i = 0; i < 8; ++i) {
            EasyMeshBuilder rim = new EasyMeshBuilder("rim_" + i, 58, 54);
            rim.addBox(-2.0f, -4.5f, 9.86f, 2.0f, 9.0f, 1.0f);
            rim.xRot = (float)i * (float)Math.PI / 4.0f;
            leftWheel.addChild(rim);
            EasyMeshBuilder spoke = new EasyMeshBuilder("spoke_" + i, 54, 54);
            spoke.addBox(-1.5f, 1.0f, -0.5f, 1.0f, 9.0f, 1.0f);
            spoke.xRot = (float)i * (float)Math.PI / 4.0f;
            leftWheel.addChild(spoke);
        }
        leftWheel.build(def.method_32111());
        EasyMeshBuilder rightWheel = new EasyMeshBuilder("rightWheel", 46, 60);
        rightWheel.setRotationPoint(-14.5f, -11.0f, 1.0f);
        rightWheel.addBox(0.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f);
        for (int i = 0; i < 8; ++i) {
            EasyMeshBuilder rim = new EasyMeshBuilder("rim_" + i, 58, 54);
            rim.addBox(0.0f, -4.5f, 9.86f, 2.0f, 9.0f, 1.0f);
            rim.xRot = (float)i * (float)Math.PI / 4.0f;
            rightWheel.addChild(rim);
            EasyMeshBuilder spoke = new EasyMeshBuilder("spoke_" + i, 54, 54);
            spoke.addBox(0.5f, 1.0f, -0.5f, 1.0f, 9.0f, 1.0f);
            spoke.xRot = (float)i * (float)Math.PI / 4.0f;
            rightWheel.addChild(spoke);
        }
        rightWheel.build(def.method_32111());
        return def;
    }

    public static EasyMeshBuilder createBody() {
        EasyMeshBuilder body = new EasyMeshBuilder("body");
        body.setRotationPoint(0.0f, -11.0f, 1.0f);
        return body;
    }
}

