/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class NiftyCartsConfig {
    public static Common get() {
        return Holder.COMMON;
    }

    public static ForgeConfigSpec spec() {
        return Holder.COMMON_SPEC;
    }

    private static final class Holder {
        private static final Common COMMON;
        private static final ForgeConfigSpec COMMON_SPEC;

        private Holder() {
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
            COMMON = (Common)specPair.getLeft();
            COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        }
    }

    public static class Common {
        public final CartConfig supplyCart;
        public final CartConfig animalCart;
        public final CartConfig plow;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration for all carts and cart-like vehicles, check log for automatic \"pull_animals\" list.").push("carts");
            this.supplyCart = new CartConfig(builder, "supply_cart", "The Supply Cart, a type of cart that stores items");
            this.animalCart = new CartConfig(builder, "animal_cart", "The Animal Cart, a type of cart to haul other animals");
            this.plow = new CartConfig(builder, "plow", "The Plow, an animal pulled machine for tilling soil and creating paths");
            builder.pop();
        }
    }

    public static class CartConfig {
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> pullAnimals;
        public final ForgeConfigSpec.DoubleValue slowSpeed;
        public final ForgeConfigSpec.DoubleValue pullSpeed;

        CartConfig(ForgeConfigSpec.Builder builder, String name, String description) {
            builder.comment(description).push(name);
            this.pullAnimals = builder.comment("Animals that are able to pull this cart, such as [\"minecraft:horse\"]\nAn empty list defaults to all which may wear a saddle but not steered by an item").define("pull_animals", new ArrayList());
            this.slowSpeed = builder.comment("Slow speed modifier toggled by the sprint key").defineInRange("slow_speed", -0.65, -1.0, 0.0);
            this.pullSpeed = builder.comment("Base speed modifier applied to animals (-0.5 = half normal speed)").defineInRange("pull_speed", 0.0, -1.0, 0.0);
            builder.pop();
        }
    }
}

