/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.ftb.mods.ftblibrary.icon.Icon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

public class CombinedIcon
extends Icon {
    public final List<Icon> list;

    public static Icon getCombined(Collection<Icon> icons) {
        ArrayList<Icon> list = new ArrayList<Icon>(icons.size());
        for (Icon icon : icons) {
            if (icon.isEmpty()) continue;
            list.add(icon);
        }
        if (list.isEmpty()) {
            return CombinedIcon.empty();
        }
        if (list.size() == 1) {
            return (Icon)list.get(0);
        }
        return new CombinedIcon(list);
    }

    CombinedIcon(Collection<Icon> icons) {
        this.list = new ArrayList<Icon>(icons.size());
        for (Icon icon : icons) {
            if (icon.isEmpty()) continue;
            this.list.add(icon);
        }
    }

    CombinedIcon(Icon o1, Icon o2) {
        this.list = new ArrayList<Icon>(2);
        this.list.add(o1);
        this.list.add(o2);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw(class_332 graphics, int x, int y, int w, int h) {
        for (Icon icon : this.list) {
            icon.draw(graphics, x, y, w, h);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawStatic(class_332 graphics, int x, int y, int w, int h) {
        for (Icon icon : this.list) {
            icon.drawStatic(graphics, x, y, w, h);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw3D(class_332 graphics) {
        for (Icon icon : this.list) {
            icon.draw3D(graphics);
        }
    }

    @Override
    public JsonElement getJson() {
        JsonArray json = new JsonArray();
        for (Icon o : this.list) {
            json.add(o.getJson());
        }
        return json;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof CombinedIcon && this.list.equals(((CombinedIcon)o).list);
    }
}

