/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditStringConfigOverlay;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractThreePanelScreen;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;

public class EditConfigListScreen<E, CV extends ConfigValue<E>>
extends AbstractThreePanelScreen<ConfigPanel> {
    private final ListConfig<E, CV> listConfig;
    private final ConfigCallback callback;
    private final List<E> localValues;
    private final int widestElement;
    private final class_2561 title;
    private final ButtonAddValue addButton;
    boolean changed = false;

    public EditConfigListScreen(ListConfig<E, CV> listConfig, ConfigCallback callback) {
        this.listConfig = listConfig;
        this.callback = callback;
        this.localValues = new ArrayList((Collection)listConfig.getValue());
        this.title = class_2561.method_43470((String)listConfig.getName()).method_27692(class_124.field_1067);
        this.addButton = new ButtonAddValue(this.topPanel);
        this.widestElement = Math.max(this.getTheme().getStringWidth((class_5348)this.title) + 25, ((List)listConfig.getValue()).stream().map(item -> this.getTheme().getStringWidth((class_5348)((ConfigValue)listConfig.getType()).getStringForGUI((Object)item))).max(Integer::compareTo).orElse(176));
    }

    @Override
    public boolean onInit() {
        int maxH = (int)((float)this.getScreen().method_4502() * 0.8f);
        int maxW = (int)((float)this.getScreen().method_4486() * 0.9f);
        this.setHeight(class_3532.method_15340((int)(this.localValues.size() * 12 + this.getTopPanelHeight() + this.bottomPanel.height), (int)176, (int)maxH));
        this.setWidth(class_3532.method_15340((int)(this.widestElement + 20), (int)176, (int)maxW));
        return true;
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    protected void doAccept() {
        if (this.changed) {
            ((List)this.listConfig.getValue()).clear();
            ((List)this.listConfig.getValue()).addAll(this.localValues);
        }
        this.callback.save(this.changed);
    }

    @Override
    protected int getTopPanelHeight() {
        return 20;
    }

    @Override
    protected Panel createTopPanel() {
        return new CustomTopPanel();
    }

    @Override
    protected ConfigPanel createMainPanel() {
        return new ConfigPanel();
    }

    @Override
    protected void doCancel() {
        if (this.changed) {
            this.openYesNo((class_2561)class_2561.method_43471((String)"ftblibrary.unsaved_changes"), (class_2561)class_2561.method_43473(), this::reallyCancel);
        } else {
            this.reallyCancel();
        }
    }

    private void reallyCancel() {
        this.callback.save(false);
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.doCancel();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if ((key.is(257) || key.is(335)) && key.modifiers.shift()) {
            this.doAccept();
            return true;
        }
        if (key.is(260)) {
            this.addButton.onClicked(MouseButton.LEFT);
            return true;
        }
        if (key.is(261)) {
            return ((ConfigPanel)this.mainPanel).getHoveredDeletable().map(d -> {
                d.deleteItem();
                return true;
            }).orElse(super.keyPressed(key));
        }
        return false;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    public class ButtonAddValue
    extends SimpleButton
    implements EditStringConfigOverlay.PosProvider {
        public ButtonAddValue(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.add"), Icons.ADD, (SimpleButton btn, MouseButton mb) -> {});
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            list.translate("gui.add", new Object[0]);
            list.styledString("[Ins]", class_124.field_1080);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            Object listType = EditConfigListScreen.this.listConfig.getType();
            ((ConfigValue)listType).setValue(((ConfigValue)listType).getDefaultValue() == null ? null : (Object)((ConfigValue)listType).copy(((ConfigValue)listType).getDefaultValue()));
            ((ConfigValue)listType).onClicked(this, button, accepted -> {
                if (accepted) {
                    EditConfigListScreen.this.localValues.add(listType.getValue());
                    EditConfigListScreen.this.changed = true;
                }
                this.openGui();
            });
        }

        @Override
        public EditStringConfigOverlay.PosProvider.Offset getOverlayOffset() {
            return new EditStringConfigOverlay.PosProvider.Offset(-this.getGui().width / 2, 20);
        }
    }

    private class CustomTopPanel
    extends AbstractThreePanelScreen.TopPanel {
        private final TextField titleLabel;

        private CustomTopPanel() {
            super(EditConfigListScreen.this);
            this.titleLabel = new TextField(this).setText(this.getTitle());
        }

        @Override
        public void addWidgets() {
            this.titleLabel.addFlags(32);
            this.add(this.titleLabel);
            if (EditConfigListScreen.this.listConfig.getCanEdit()) {
                this.add(EditConfigListScreen.this.addButton);
            }
        }

        @Override
        public void alignWidgets() {
            this.titleLabel.setPosAndSize(4, 0, this.titleLabel.width, this.height);
            EditConfigListScreen.this.addButton.setPosAndSize(this.width - 18, 1, 16, 16);
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            super.draw(graphics, theme, x, y, w, h);
            theme.drawString(graphics, this.getGui().getTitle(), x + 6, y + 6, 2);
        }
    }

    public class ConfigPanel
    extends Panel {
        public ConfigPanel() {
            super(EditConfigListScreen.this);
        }

        @Override
        public void addWidgets() {
            for (int i = 0; i < EditConfigListScreen.this.localValues.size(); ++i) {
                this.add(new ButtonConfigValue(i));
            }
        }

        @Override
        public void alignWidgets() {
            for (Widget w : this.widgets) {
                w.setX(2);
                w.setWidth(this.width - 4);
            }
            this.align(WidgetLayout.VERTICAL);
        }

        public Optional<Deletable> getHoveredDeletable() {
            return this.getWidgets().stream().filter(w -> w.isMouseOver() && w instanceof Deletable).map(w -> (Deletable)((Object)w)).findFirst();
        }
    }

    @FunctionalInterface
    public static interface Deletable {
        public void deleteItem();
    }

    public class ButtonConfigValue
    extends Button
    implements Deletable,
    EditStringConfigOverlay.PosProvider {
        private static final class_2561 DEL_BUTTON_TXT = class_2561.method_43470((String)"[").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)"X").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1061));
        public final int index;

        public ButtonConfigValue(int index) {
            super(EditConfigListScreen.this.mainPanel);
            this.index = index;
            this.setHeight(12);
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            MutableColor4I textCol = ((ConfigValue)EditConfigListScreen.this.listConfig.getType()).getColor(EditConfigListScreen.this.localValues.get(this.index)).mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
                if (this.getMouseX() >= x + w - 19) {
                    Color4I.WHITE.withAlpha(33).draw(graphics, x + w - 19, y, 19, h);
                }
            }
            theme.drawString(graphics, this.getGui().getTheme().trimStringToWidth((class_5348)((ConfigValue)EditConfigListScreen.this.listConfig.getType()).getStringForGUI(EditConfigListScreen.this.localValues.get(this.index)), this.width), x + 4, y + 2, textCol, 0);
            if (mouseOver) {
                theme.drawString(graphics, DEL_BUTTON_TXT, x + w - 16, y + 2, Color4I.WHITE, 0);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                if (EditConfigListScreen.this.listConfig.getCanEdit()) {
                    this.deleteItem();
                }
            } else {
                ((ConfigValue)EditConfigListScreen.this.listConfig.getType()).setValue(EditConfigListScreen.this.localValues.get(this.index));
                ((ConfigValue)EditConfigListScreen.this.listConfig.getType()).onClicked(this, button, accepted -> {
                    if (accepted) {
                        EditConfigListScreen.this.localValues.set(this.index, ((ConfigValue)EditConfigListScreen.this.listConfig.getType()).getValue());
                        EditConfigListScreen.this.changed = true;
                    }
                    this.openGui();
                });
            }
        }

        @Override
        public void addMouseOverText(TooltipList l) {
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                l.translate("selectServer.delete", new Object[0]);
                l.add(TextComponentUtils.hotkeyTooltip("Del"));
            } else {
                ((ConfigValue)EditConfigListScreen.this.listConfig.getType()).setValue(EditConfigListScreen.this.localValues.get(this.index));
                ((ConfigValue)EditConfigListScreen.this.listConfig.getType()).addInfo(l);
            }
        }

        @Override
        public void deleteItem() {
            EditConfigListScreen.this.localValues.remove(this.index);
            EditConfigListScreen.this.changed = true;
            this.parent.refreshWidgets();
        }

        @Override
        public EditStringConfigOverlay.PosProvider.Offset getOverlayOffset() {
            return new EditStringConfigOverlay.PosProvider.Offset(0, 0);
        }
    }
}

