/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.mod.util;

import com.dfsek.terra.api.block.entity.BlockEntity;
import com.dfsek.terra.api.block.entity.Container;
import com.dfsek.terra.api.block.entity.MobSpawner;
import com.dfsek.terra.api.block.entity.Sign;
import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.registry.key.RegistryKey;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.mod.config.VanillaBiomeProperties;
import com.dfsek.terra.mod.mixin.access.BiomeAccessor;
import com.dfsek.terra.mod.mixin_ifaces.FloraFeatureHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2625;
import net.minecraft.class_2636;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5485;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinecraftUtil {
    public static final Logger logger = LoggerFactory.getLogger(MinecraftUtil.class);
    public static final Map<class_2960, List<class_2960>> TERRA_BIOME_MAP = new HashMap<class_2960, List<class_2960>>();

    private MinecraftUtil() {
    }

    public static <T> Optional<class_6880<T>> getEntry(class_2378<T> registry, class_2960 identifier) {
        return registry.method_17966(identifier).flatMap(arg_0 -> registry.method_29113(arg_0)).flatMap(arg_0 -> registry.method_40264(arg_0));
    }

    public static BlockEntity createState(class_1936 worldAccess, class_2338 pos) {
        class_2586 entity = worldAccess.method_8321(pos);
        if (entity instanceof class_2625) {
            return (Sign)entity;
        }
        if (entity instanceof class_2636) {
            return (MobSpawner)entity;
        }
        if (entity instanceof class_2621) {
            return (Container)entity;
        }
        return null;
    }

    public static void registerFlora(class_2378<class_1959> biomes) {
        logger.info("Injecting flora into Terra biomes...");
        TERRA_BIOME_MAP.forEach((vb, terraBiomes) -> biomes.method_17966(vb).ifPresentOrElse(vanilla -> terraBiomes.forEach(tb -> biomes.method_17966(tb).ifPresentOrElse(terra -> {
            List<class_2975<?, ?>> flowerFeatures = List.copyOf(vanilla.method_30970().method_30982());
            logger.debug("Injecting flora into biome {} : {}", tb, flowerFeatures);
            ((FloraFeatureHolder)terra.method_30970()).setFloraFeatures(flowerFeatures);
        }, () -> logger.error("No such biome: {}", tb))), () -> logger.error("No vanilla biome: {}", vb)));
    }

    public static Map<class_2960, List<class_2960>> getTerraBiomeMap() {
        return Map.copyOf(TERRA_BIOME_MAP);
    }

    public static class_5321<class_1959> registerKey(class_2960 identifier) {
        return class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)identifier);
    }

    public static class_1959 createBiome(Biome biome, class_1959 vanilla, VanillaBiomeProperties vanillaBiomeProperties) {
        class_5485.class_7868 generationSettings = new class_5485.class_7868();
        class_4763.class_4764 effects = new class_4763.class_4764();
        class_1959.class_1960 builder = new class_1959.class_1960();
        effects.method_24395(Objects.requireNonNullElse(vanillaBiomeProperties.getWaterColor(), vanilla.method_8687()).intValue()).method_24397(Objects.requireNonNullElse(vanillaBiomeProperties.getWaterFogColor(), vanilla.method_8713()).intValue()).method_24392(Objects.requireNonNullElse(vanillaBiomeProperties.getFogColor(), vanilla.method_24376()).intValue()).method_30820(Objects.requireNonNullElse(vanillaBiomeProperties.getSkyColor(), vanilla.method_8697()).intValue()).method_30818(Objects.requireNonNullElse(vanillaBiomeProperties.getGrassColorModifier(), vanilla.method_24377().method_30814()));
        if (vanillaBiomeProperties.getFoliageColor() == null) {
            vanilla.method_24377().method_30811().ifPresent(arg_0 -> ((class_4763.class_4764)effects).method_30821(arg_0));
        } else {
            effects.method_30821(vanillaBiomeProperties.getFoliageColor().intValue());
        }
        if (vanillaBiomeProperties.getGrassColor() == null) {
            vanilla.method_24377().method_30812().ifPresent(arg_0 -> ((class_4763.class_4764)effects).method_30822(arg_0));
        } else {
            effects.method_30822(vanillaBiomeProperties.getGrassColor().intValue());
        }
        if (vanillaBiomeProperties.getParticleConfig() == null) {
            vanilla.method_24377().method_24390().ifPresent(arg_0 -> ((class_4763.class_4764)effects).method_24393(arg_0));
        } else {
            effects.method_24393(vanillaBiomeProperties.getParticleConfig());
        }
        if (vanillaBiomeProperties.getLoopSound() == null) {
            vanilla.method_24377().method_24939().ifPresent(arg_0 -> ((class_4763.class_4764)effects).method_24942(arg_0));
        } else {
            effects.method_24942(class_7923.field_41172.method_47983((Object)vanillaBiomeProperties.getLoopSound()));
        }
        if (vanillaBiomeProperties.getMoodSound() == null) {
            vanilla.method_24377().method_24940().ifPresent(arg_0 -> ((class_4763.class_4764)effects).method_24943(arg_0));
        } else {
            effects.method_24943(vanillaBiomeProperties.getMoodSound());
        }
        if (vanillaBiomeProperties.getAdditionsSound() == null) {
            vanilla.method_24377().method_24941().ifPresent(arg_0 -> ((class_4763.class_4764)effects).method_24944(arg_0));
        } else {
            effects.method_24944(vanillaBiomeProperties.getAdditionsSound());
        }
        if (vanillaBiomeProperties.getMusic() == null) {
            vanilla.method_24377().method_27345().ifPresent(arg_0 -> ((class_4763.class_4764)effects).method_27346(arg_0));
        } else {
            effects.method_27346(vanillaBiomeProperties.getMusic());
        }
        builder.method_48164(Objects.requireNonNullElse(vanillaBiomeProperties.getPrecipitation(), vanilla.method_48163()).booleanValue());
        builder.method_8747(Objects.requireNonNullElse(vanillaBiomeProperties.getTemperature(), Float.valueOf(vanilla.method_8712())).floatValue());
        builder.method_8727(Objects.requireNonNullElse(vanillaBiomeProperties.getDownfall(), Float.valueOf(((BiomeAccessor)vanilla).getWeather().comp_846())).floatValue());
        builder.method_30777(Objects.requireNonNullElse(vanillaBiomeProperties.getTemperatureModifier(), ((BiomeAccessor)vanilla).getWeather().comp_845()));
        builder.method_30974(Objects.requireNonNullElse(vanillaBiomeProperties.getSpawnSettings(), vanilla.method_30966()));
        return builder.method_24379(effects.method_24391()).method_30973(generationSettings.method_46671()).method_30972();
    }

    public static String createBiomeID(ConfigPack pack, RegistryKey biomeID) {
        return pack.getID().toLowerCase() + "/" + biomeID.getNamespace().toLowerCase(Locale.ROOT) + "/" + biomeID.getID().toLowerCase(Locale.ROOT);
    }
}

