/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.mod.generation;

import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import com.dfsek.terra.api.world.chunk.generation.ChunkGenerator;
import com.dfsek.terra.api.world.chunk.generation.ProtoChunk;
import com.dfsek.terra.api.world.chunk.generation.ProtoWorld;
import com.dfsek.terra.api.world.chunk.generation.stage.Chunkified;
import com.dfsek.terra.api.world.chunk.generation.util.GeneratorWrapper;
import com.dfsek.terra.api.world.info.WorldProperties;
import com.dfsek.terra.mod.config.PreLoadCompatibilityOptions;
import com.dfsek.terra.mod.data.Codecs;
import com.dfsek.terra.mod.generation.TerraBiomeSource;
import com.dfsek.terra.mod.mixin.access.StructureAccessorAccessor;
import com.dfsek.terra.mod.util.MinecraftAdapter;
import com.dfsek.terra.mod.util.SeedHack;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1948;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_5817;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6673;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7138;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftChunkGeneratorWrapper
extends class_2794
implements GeneratorWrapper {
    private static final Logger logger = LoggerFactory.getLogger(MinecraftChunkGeneratorWrapper.class);
    private final TerraBiomeSource biomeSource;
    private final class_6880<class_5284> settings;
    private ChunkGenerator delegate;
    private ConfigPack pack;

    public MinecraftChunkGeneratorWrapper(TerraBiomeSource biomeSource, ConfigPack configPack, class_6880<class_5284> settingsSupplier) {
        super((class_1966)biomeSource);
        this.pack = configPack;
        this.settings = settingsSupplier;
        this.delegate = this.pack.getGeneratorProvider().newInstance(this.pack);
        logger.info("Loading world with config pack {}", (Object)this.pack.getID());
        this.biomeSource = biomeSource;
    }

    protected Codec<? extends class_2794> method_28506() {
        return Codecs.MINECRAFT_CHUNK_GENERATOR_WRAPPER;
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public void method_12107(class_3233 region) {
        if (!((class_5284)this.settings.comp_349()).comp_480()) {
            class_1923 chunkPos = region.method_33561();
            class_6880 registryEntry = region.method_23753(chunkPos.method_8323().method_33096(region.method_31600() - 1));
            class_2919 chunkRandom = new class_2919((class_5819)new class_5820(class_6673.method_39001()));
            chunkRandom.method_12661(region.method_8412(), chunkPos.method_8326(), chunkPos.method_8328());
            class_1948.method_8661((class_5425)region, (class_6880)registryEntry, (class_1923)chunkPos, (class_5819)chunkRandom);
        }
    }

    public int method_12104() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_174();
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return CompletableFuture.supplyAsync(() -> {
            ProtoWorld world = (ProtoWorld)((StructureAccessorAccessor)structureAccessor).getWorld();
            BiomeProvider biomeProvider = this.pack.getBiomeProvider();
            this.delegate.generateChunkData((ProtoChunk)chunk, world, biomeProvider, chunk.method_12004().field_9181, chunk.method_12004().field_9180);
            PreLoadCompatibilityOptions compatibilityOptions = this.pack.getContext().get(PreLoadCompatibilityOptions.class);
            if (compatibilityOptions.isBeard()) {
                this.beard(structureAccessor, chunk, world, biomeProvider, compatibilityOptions);
            }
            return chunk;
        }, class_156.method_18349());
    }

    private void beard(class_5138 structureAccessor, class_2791 chunk, WorldProperties world, BiomeProvider biomeProvider, PreLoadCompatibilityOptions compatibilityOptions) {
        class_5817 structureWeightSampler = class_5817.method_42695((class_5138)structureAccessor, (class_1923)chunk.method_12004());
        double threshold = compatibilityOptions.getBeardThreshold();
        double airThreshold = compatibilityOptions.getAirThreshold();
        int xi = chunk.method_12004().field_9181 << 4;
        int zi = chunk.method_12004().field_9180 << 4;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int depth = 0;
                for (int y = world.getMaxHeight(); y >= world.getMinHeight(); --y) {
                    double noise = structureWeightSampler.method_40464((class_6910.class_6912)new class_6910.class_6914(x + xi, y, z + zi));
                    if (noise > threshold) {
                        chunk.method_12010(new class_2338(x, y, z), (class_2680)this.delegate.getPalette(x + xi, y, z + zi, world, biomeProvider).get(depth, x + xi, y, z + zi, world.getSeed()), false);
                        ++depth;
                        continue;
                    }
                    if (noise < airThreshold) {
                        chunk.method_12010(new class_2338(x, y, z), class_2246.field_10124.method_9564(), false);
                        continue;
                    }
                    depth = 0;
                }
            }
        }
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        super.method_12102(world, chunk, structureAccessor);
        this.pack.getStages().forEach(populator -> {
            if (!(populator instanceof Chunkified)) {
                populator.populate((ProtoWorld)world);
            }
        });
    }

    public int method_16398() {
        return ((class_5284)this.settings.comp_349()).comp_479();
    }

    public int method_33730() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_173();
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 height, class_7138 noiseConfig) {
        WorldProperties properties = MinecraftAdapter.adapt(height, SeedHack.getSeed(noiseConfig.method_42371()));
        BiomeProvider biomeProvider = this.pack.getBiomeProvider();
        int min2 = height.method_31607();
        for (int y = height.method_31600() - 1; y >= min2; --y) {
            if (!heightmap.method_16402().test((class_2680)this.delegate.getBlock(properties, x, y, z, biomeProvider))) continue;
            return y + 1;
        }
        return min2;
    }

    public class_4966 method_26261(int x, int z, class_5539 height, class_7138 noiseConfig) {
        class_2680[] array = new class_2680[height.method_31605()];
        WorldProperties properties = MinecraftAdapter.adapt(height, SeedHack.getSeed(noiseConfig.method_42371()));
        BiomeProvider biomeProvider = this.pack.getBiomeProvider();
        for (int y = height.method_31600() - 1; y >= height.method_31607(); --y) {
            array[y - height.method_31607()] = (class_2680)this.delegate.getBlock(properties, x, y, z, biomeProvider);
        }
        return new class_4966(height.method_31607(), array);
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }

    public ConfigPack getPack() {
        return this.pack;
    }

    public void setPack(ConfigPack pack) {
        this.pack = pack;
        this.delegate = pack.getGeneratorProvider().newInstance(pack);
        this.biomeSource.setPack(pack);
        logger.debug("Loading world with config pack {}", (Object)pack.getID());
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 world, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {
    }

    @Override
    public ChunkGenerator getHandle() {
        return this.delegate;
    }

    public class_6880<class_5284> getSettings() {
        return this.settings;
    }

    public TerraBiomeSource getBiomeSource() {
        return this.biomeSource;
    }
}

