/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.lifecycle.util;

import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.registry.key.RegistryKey;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.mod.CommonPlatform;
import com.dfsek.terra.mod.config.PreLoadCompatibilityOptions;
import com.dfsek.terra.mod.config.ProtoPlatformBiome;
import com.dfsek.terra.mod.config.VanillaBiomeProperties;
import com.dfsek.terra.mod.mixin.access.VillagerTypeAccessor;
import com.dfsek.terra.mod.util.MinecraftUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiomeUtil {
    private static final Logger logger = LoggerFactory.getLogger(BiomeUtil.class);

    private BiomeUtil() {
    }

    public static void registerBiomes(class_2378<class_1959> biomeRegistry) {
        logger.info("Registering biomes...");
        CommonPlatform.get().getConfigRegistry().forEach(pack -> pack.getCheckedRegistry(Biome.class).forEach((id, biome) -> BiomeUtil.registerBiome(biome, pack, id, biomeRegistry)));
        logger.info("Terra biomes registered.");
    }

    private static void registerBiome(Biome biome, ConfigPack pack, RegistryKey id, class_2378<class_1959> registry) {
        class_5321<class_1959> vanilla = ((ProtoPlatformBiome)biome.getPlatformBiome()).get(registry);
        if (pack.getContext().get(PreLoadCompatibilityOptions.class).useVanillaBiomes()) {
            ((ProtoPlatformBiome)biome.getPlatformBiome()).setDelegate((class_6880<class_1959>)((class_6880)registry.method_40264(vanilla).orElseThrow()));
        } else {
            VanillaBiomeProperties vanillaBiomeProperties = biome.getContext().get(VanillaBiomeProperties.class);
            class_1959 minecraftBiome = MinecraftUtil.createBiome(biome, Objects.requireNonNull((class_1959)registry.method_29107(vanilla)), vanillaBiomeProperties);
            class_2960 identifier = new class_2960("terra", MinecraftUtil.createBiomeID(pack, id));
            if (registry.method_10250(identifier)) {
                ((ProtoPlatformBiome)biome.getPlatformBiome()).setDelegate(MinecraftUtil.getEntry(registry, identifier).orElseThrow());
            } else {
                ((ProtoPlatformBiome)biome.getPlatformBiome()).setDelegate((class_6880<class_1959>)class_2378.method_47985(registry, (class_2960)MinecraftUtil.registerKey(identifier).method_29177(), (Object)minecraftBiome));
            }
            Map<class_5321<class_1959>, class_3854> villagerMap = VillagerTypeAccessor.getBiomeTypeToIdMap();
            villagerMap.put((class_5321<class_1959>)class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)identifier), Objects.requireNonNullElse(vanillaBiomeProperties.getVillagerType(), villagerMap.getOrDefault(vanilla, class_3854.field_17073)));
            MinecraftUtil.TERRA_BIOME_MAP.computeIfAbsent(vanilla.method_29177(), i -> new ArrayList()).add(identifier);
        }
    }
}

