/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.lib.commons.text.similarity;

import com.dfsek.terra.lib.commons.text.similarity.CosineSimilarity;
import com.dfsek.terra.lib.commons.text.similarity.Counter;
import com.dfsek.terra.lib.commons.text.similarity.EditDistance;
import com.dfsek.terra.lib.commons.text.similarity.RegexTokenizer;
import com.dfsek.terra.lib.commons.text.similarity.Tokenizer;
import java.util.Map;

public class CosineDistance
implements EditDistance<Double> {
    private final Tokenizer<CharSequence> tokenizer = new RegexTokenizer();
    private final CosineSimilarity cosineSimilarity = new CosineSimilarity();

    @Override
    public Double apply(CharSequence left, CharSequence right) {
        CharSequence[] leftTokens = this.tokenizer.tokenize(left);
        CharSequence[] rightTokens = this.tokenizer.tokenize(right);
        Map<CharSequence, Integer> leftVector = Counter.of(leftTokens);
        Map<CharSequence, Integer> rightVector = Counter.of(rightTokens);
        double similarity = this.cosineSimilarity.cosineSimilarity(leftVector, rightVector);
        return 1.0 - similarity;
    }
}

