/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.fabric;

import ca.solostudios.strata.Versions;
import ca.solostudios.strata.parser.tokenizer.ParseException;
import ca.solostudios.strata.version.Version;
import com.dfsek.terra.addon.EphemeralAddon;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.fabric.FabricAddon;
import com.dfsek.terra.lifecycle.LifecyclePlatform;
import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricPlatform
extends LifecyclePlatform {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricPlatform.class);

    @Override
    protected Collection<BaseAddon> getPlatformMods() {
        return FabricLoader.getInstance().getAllMods().stream().flatMap(mod -> {
            String id = mod.getMetadata().getId();
            if (id.equals("terra") || id.equals("minecraft") || id.equals("java")) {
                return Stream.empty();
            }
            try {
                Version version = Versions.parseVersion(mod.getMetadata().getVersion().getFriendlyString());
                return Stream.of(new EphemeralAddon(version, "fabric:" + id));
            }
            catch (ParseException e) {
                LOGGER.warn("Mod {}, version {} does not follow semantic versioning specification, Terra addons will be unable to depend on it.", (Object)id, (Object)mod.getMetadata().getVersion().getFriendlyString());
                return Stream.empty();
            }
        }).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public String platformName() {
        return "Fabric";
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return new File(FabricLoader.getInstance().getConfigDir().toFile(), "Terra");
    }

    @Override
    public BaseAddon getPlatformAddon() {
        return new FabricAddon(this);
    }
}

