/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.preprocessor;

import com.dfsek.tectonic.api.config.Configuration;
import com.dfsek.tectonic.api.depth.DepthTracker;
import com.dfsek.tectonic.api.exception.LoadException;
import com.dfsek.tectonic.api.loader.ConfigLoader;
import com.dfsek.tectonic.api.preprocessor.Result;
import com.dfsek.terra.api.config.meta.Meta;
import com.dfsek.terra.api.util.reflection.TypeKey;
import com.dfsek.terra.config.preprocessor.MetaPreprocessor;
import com.dfsek.terra.lib.paralithic.eval.parser.Parser;
import com.dfsek.terra.lib.paralithic.eval.tokenizer.ParseException;
import java.lang.reflect.AnnotatedType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MetaNumberPreprocessor
extends MetaPreprocessor<Meta> {
    public static final TypeKey<String> META_STRING_KEY = new TypeKey<String>(){};

    public MetaNumberPreprocessor(Map<String, Configuration> configs) {
        super(configs);
    }

    private static boolean isNumber(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz) || Byte.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz);
    }

    @Override
    @NotNull
    public <T> Result<T> process(AnnotatedType t2, T c, ConfigLoader loader, Meta annotation, DepthTracker depthTracker) {
        if (t2.getType() instanceof Class && MetaNumberPreprocessor.isNumber((Class)t2.getType()) && c instanceof String) {
            String expression = (String)loader.loadType(META_STRING_KEY.getAnnotatedType(), c, depthTracker);
            try {
                return Result.overwrite(new Parser().eval(expression), depthTracker);
            }
            catch (ParseException e) {
                throw new LoadException("Invalid expression: ", e, depthTracker);
            }
        }
        return Result.noOp();
    }
}

