/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util;

import net.jafama.FastMath;

public enum Rotation {
    CW_90(90),
    CW_180(180),
    CCW_90(270),
    NONE(0);

    private final int degrees;

    private Rotation(int degrees2) {
        this.degrees = degrees2;
    }

    public static Rotation fromDegrees(int deg) {
        return switch (FastMath.floorMod(deg, 360)) {
            case 0 -> NONE;
            case 90 -> CW_90;
            case 180 -> CW_180;
            case 270 -> CCW_90;
            default -> throw new IllegalArgumentException();
        };
    }

    public Rotation inverse() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> NONE;
            case CCW_90 -> CW_90;
            case CW_90 -> CCW_90;
            case CW_180 -> CW_180;
        };
    }

    public Rotation rotate(Rotation rotation) {
        return Rotation.fromDegrees(this.getDegrees() + rotation.getDegrees());
    }

    public int getDegrees() {
        return this.degrees;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

