/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util;

import java.util.List;
import net.jafama.FastMath;

public final class MathUtil {
    public static final double EPSILON = 1.0E-5;

    public static double standardDeviation(List<Number> numArray) {
        double sum = 0.0;
        double standardDeviation = 0.0;
        int length = numArray.size();
        for (Number num : numArray) {
            sum += num.doubleValue();
        }
        double mean = sum / (double)length;
        for (Number num : numArray) {
            standardDeviation += FastMath.pow2(num.doubleValue() - mean);
        }
        return FastMath.sqrt(standardDeviation / (double)length);
    }

    public static long hashToLong(String s2) {
        if (s2 == null) {
            return 0L;
        }
        long hash = 0L;
        for (char c : s2.toCharArray()) {
            hash = 31L * hash + (long)c;
        }
        return hash;
    }

    public static boolean equals(double a, double b) {
        return a == b || FastMath.abs(a - b) < 1.0E-5;
    }

    public static int normalizeIndex(double val, int size) {
        return FastMath.max(FastMath.min(FastMath.floorToInt((val + 1.0) / 2.0 * (double)size), size - 1), 0);
    }

    public static long squash(int first, int last) {
        return (long)first << 32 | (long)last & 0xFFFFFFFFL;
    }

    public static double clamp(double in) {
        return FastMath.min(FastMath.max(in, -1.0), 1.0);
    }

    public static int clamp(int min2, int i, int max) {
        return FastMath.max(FastMath.min(i, max), min2);
    }

    public static double normalInverse(double p, double mu, double sigma) {
        double val;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Probability must be in range [0, 1]");
        }
        if (sigma < 0.0) {
            throw new IllegalArgumentException("Standard deviation must be positive.");
        }
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (sigma == 0.0) {
            return mu;
        }
        double q = p - 0.5;
        if (FastMath.abs(q) <= 0.425) {
            double r = 0.180625 - q * q;
            val = q * (((((((r * 2509.0809287301227 + 33430.57558358813) * r + 67265.7709270087) * r + 45921.95393154987) * r + 13731.69376550946) * r + 1971.5909503065513) * r + 133.14166789178438) * r + 3.3871328727963665) / (((((((r * 5226.495278852854 + 28729.085735721943) * r + 39307.89580009271) * r + 21213.794301586597) * r + 5394.196021424751) * r + 687.1870074920579) * r + 42.31333070160091) * r + 1.0);
        } else {
            double r = q > 0.0 ? 1.0 - p : p;
            r = FastMath.sqrt(-FastMath.log(r));
            val = r <= 5.0 ? ((((((((r -= 1.6) * 7.745450142783414E-4 + 0.022723844989269184) * r + 0.2417807251774506) * r + 1.2704582524523684) * r + 3.6478483247632045) * r + 5.769497221460691) * r + 4.630337846156546) * r + 1.4234371107496835) / (((((((r * 1.0507500716444169E-9 + 5.475938084995345E-4) * r + 0.015198666563616457) * r + 0.14810397642748008) * r + 0.6897673349851) * r + 1.6763848301838038) * r + 2.053191626637759) * r + 1.0) : ((((((((r -= 5.0) * 2.0103343992922881E-7 + 2.7115555687434876E-5) * r + 0.0012426609473880784) * r + 0.026532189526576124) * r + 0.29656057182850487) * r + 1.7848265399172913) * r + 5.463784911164114) * r + 6.657904643501103) / (((((((r * 2.0442631033899397E-15 + 1.421511758316446E-7) * r + 1.8463183175100548E-5) * r + 7.868691311456133E-4) * r + 0.014875361290850615) * r + 0.1369298809227358) * r + 0.599832206555888) * r + 1.0);
            if (q < 0.0) {
                val = -val;
            }
        }
        return mu + sigma * val;
    }
}

