/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util;

import com.dfsek.terra.api.util.function.IntIntObjConsumer;
import com.dfsek.terra.api.util.function.IntObjConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public interface Column<T> {
    public int getMinY();

    public int getMaxY();

    public int getX();

    public int getZ();

    public T get(int var1);

    default public void forEach(Consumer<T> consumer) {
        for (int y = this.getMinY(); y < this.getMaxY(); ++y) {
            consumer.accept(this.get(y));
        }
    }

    default public void forEach(IntObjConsumer<T> consumer) {
        for (int y = this.getMinY(); y < this.getMaxY(); ++y) {
            consumer.accept(y, this.get(y));
        }
    }

    default public void forRanges(int resolution, IntIntObjConsumer<T> consumer) {
        int min2;
        int y = min2 = this.getMinY();
        T runningObj = this.get(y);
        int runningMin = min2;
        int max = this.getMaxY() - 1;
        while ((y += resolution) <= max) {
            T current = this.get(y);
            if (current.equals(runningObj)) continue;
            consumer.accept(runningMin, y, runningObj);
            runningMin = y;
            runningObj = current;
        }
        consumer.accept(runningMin, this.getMaxY(), runningObj);
    }

    default public List<? extends T> asList() {
        ArrayList list = new ArrayList();
        this.forEach(list::add);
        return list;
    }
}

