/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.tectonic.api.preprocessor;

import com.dfsek.tectonic.api.depth.DepthTracker;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class Result<T>
implements UnaryOperator<T> {
    private final TransformType type;
    private final T overwritten;
    private final Consumer<T> transformer;
    private final DepthTracker tracker;

    private Result(T overwritten, Consumer<T> transformer, TransformType type, DepthTracker tracker) {
        this.type = type;
        this.overwritten = overwritten;
        this.transformer = transformer;
        this.tracker = tracker;
    }

    public static <T> Result<T> overwrite(T result, DepthTracker tracker) {
        return new Result<T>(result, null, TransformType.OVERWRITE, tracker);
    }

    public static <T> Result<T> noOp() {
        return new Result<Object>(null, null, TransformType.NOP, null);
    }

    public static <T> Result<T> transform(@NotNull Consumer<T> transformer, DepthTracker tracker) {
        Objects.requireNonNull(transformer);
        return new Result<Object>(null, transformer, TransformType.TRANSFORM, tracker);
    }

    public static <T> Result<T> transform(@NotNull Consumer<T> transformer) {
        Objects.requireNonNull(transformer);
        return new Result<Object>(null, transformer, TransformType.TRANSFORM, null);
    }

    @Override
    public T apply(T t2) {
        switch (this.type) {
            case NOP: {
                return t2;
            }
            case OVERWRITE: {
                return this.overwritten;
            }
            case TRANSFORM: {
                this.transformer.accept(t2);
                return t2;
            }
        }
        return t2;
    }

    public DepthTracker getTracker(DepthTracker original) {
        if (this.tracker == null) {
            return original;
        }
        return this.tracker;
    }

    private static enum TransformType {
        OVERWRITE,
        TRANSFORM,
        NOP;

    }
}

