/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.Description;
import cloud.commandframework.arguments.CommandArgument;
import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE, since="1.3.0")
public final class CommandComponent<C> {
    private final CommandArgument<C, ?> argument;
    private final ArgumentDescription description;

    private CommandComponent(@NonNull CommandArgument<C, ?> commandArgument, @NonNull ArgumentDescription commandDescription) {
        this.argument = commandArgument;
        this.description = commandDescription;
    }

    public @NonNull CommandArgument<C, ?> getArgument() {
        return this.argument;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4.0")
    public @NonNull Description getDescription() {
        if (this.description instanceof Description) {
            return (Description)this.description;
        }
        return new Description(this.description.getDescription());
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public @NonNull ArgumentDescription getArgumentDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hash(this.getArgument(), this.getArgumentDescription());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CommandComponent) {
            CommandComponent that = (CommandComponent)o;
            return this.getArgument().equals(that.getArgument()) && this.getArgumentDescription().equals(that.getArgumentDescription());
        }
        return false;
    }

    public @NonNull String toString() {
        return String.format("%s{argument=%s,description=%s}", this.getClass().getSimpleName(), this.argument, this.description);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4.0")
    public static <C> @NonNull CommandComponent<C> of(@NonNull CommandArgument<C, ?> commandArgument, @NonNull Description commandDescription) {
        return new CommandComponent<C>(commandArgument, commandDescription);
    }

    public static <C> @NonNull CommandComponent<C> of(@NonNull CommandArgument<C, ?> commandArgument, @NonNull ArgumentDescription commandDescription) {
        return new CommandComponent<C>(commandArgument, commandDescription);
    }
}

