/*
 * Decompiled with CFR 0.152.
 */
package ca.solostudios.strata.parser.tokenizer;

import ca.solostudios.strata.parser.tokenizer.Position;
import org.jetbrains.annotations.NotNull;

public class Char
implements Position {
    private final char value;
    private final int pos;

    public Char(char value, int pos) {
        this.value = value;
        this.pos = pos;
    }

    public String toString() {
        if (this.isEndOfInput()) {
            return "<EOI>";
        }
        return String.valueOf(this.value);
    }

    public boolean is(char test) {
        return test == this.value && test != '\u0000';
    }

    public boolean is(char ... tests) {
        for (char test : tests) {
            if (test != this.value || test == '\u0000') continue;
            return true;
        }
        return false;
    }

    public char getValue() {
        return this.value;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    public boolean isAlphaNumeric() {
        return this.isLetter() || this.isDigit() || this.is('-');
    }

    public boolean isDigit() {
        return this.value >= '0' && this.value <= '9';
    }

    public boolean isLetter() {
        return this.value >= 'a' && this.value <= 'z' || this.value >= 'A' && this.value <= 'Z';
    }

    public boolean isEndOfInput() {
        return this.value == '\u0000';
    }

    @NotNull
    public String getStringValue() {
        if (this.isEndOfInput()) {
            return "";
        }
        return String.valueOf(this.value);
    }
}

