/*
 * Decompiled with CFR 0.152.
 */
package ca.solostudios.strata.parser;

import ca.solostudios.strata.parser.tokenizer.Char;
import ca.solostudios.strata.parser.tokenizer.LookaheadReader;
import ca.solostudios.strata.parser.tokenizer.ParseException;
import ca.solostudios.strata.parser.tokenizer.Position;
import ca.solostudios.strata.version.BuildMetadata;
import ca.solostudios.strata.version.CoreVersion;
import ca.solostudios.strata.version.PreRelease;
import ca.solostudios.strata.version.PreReleaseIdentifier;
import ca.solostudios.strata.version.Version;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class VersionParser {
    private static final char PLUS = '+';
    private static final char DOT = '.';
    private static final char DASH = '-';
    @NotNull
    private final LookaheadReader input;
    @NotNull
    private final String versionString;

    public VersionParser(@NotNull String versionString) {
        this.input = new LookaheadReader(new StringReader(versionString));
        this.versionString = versionString;
    }

    @NotNull
    @Contract(value="-> new", pure=true)
    public Version parse() throws ParseException {
        CoreVersion coreVersion = this.parseCoreVersion();
        PreRelease preRelease = PreRelease.NULL;
        BuildMetadata buildMetadata = BuildMetadata.NULL;
        Char next = (Char)this.input.consume();
        if (next.is('-')) {
            preRelease = this.parsePreRelease();
            next = (Char)this.input.consume();
        }
        if (next.is('+')) {
            buildMetadata = this.parseBuildMetadata();
            next = (Char)this.input.consume();
        }
        if (next.isEndOfInput()) {
            return new Version(coreVersion, preRelease, buildMetadata);
        }
        throw new ParseException("Expected end of version. Illegal character found.", this.versionString, (Position)next);
    }

    private CoreVersion parseCoreVersion() throws ParseException {
        BigInteger major = new BigInteger(this.consumeNumber());
        this.consumeCharacter('.');
        BigInteger minor = new BigInteger(this.consumeNumber());
        this.consumeCharacter('.');
        BigInteger patch = new BigInteger(this.consumeNumber());
        return new CoreVersion(major, minor, patch);
    }

    private PreRelease parsePreRelease() throws ParseException {
        ArrayList<PreReleaseIdentifier> identifiers = new ArrayList<PreReleaseIdentifier>();
        identifiers.add(this.parsePreReleaseIdentifier());
        while (((Char)this.input.current()).is('.')) {
            this.input.consume();
            identifiers.add(this.parsePreReleaseIdentifier());
        }
        return new PreRelease(identifiers);
    }

    private PreReleaseIdentifier parsePreReleaseIdentifier() throws ParseException {
        if (this.lookaheadAlphaNumeric()) {
            return new PreReleaseIdentifier.AlphaNumericalPreReleaseIdentifier(this.consumeAlphaNumeric());
        }
        return new PreReleaseIdentifier.NumericalPreReleaseIdentifier(new BigInteger(this.consumeNumber()));
    }

    private PreReleaseIdentifier.AlphaNumericalPreReleaseIdentifier parseAlphaNumericPreReleaseIdentifier() throws ParseException {
        return new PreReleaseIdentifier.AlphaNumericalPreReleaseIdentifier(this.consumeAlphaNumeric());
    }

    private BuildMetadata parseBuildMetadata() throws ParseException {
        StringBuilder sb = new StringBuilder();
        if (!((Char)this.input.current()).isAlphaNumeric()) {
            throw new ParseException("Alpha-Numeric identifier expected.", this.versionString, (Position)this.input.current());
        }
        do {
            Char consumed;
            if ((consumed = (Char)this.input.consume()).is('.')) {
                if (((Char)this.input.current()).is('.')) {
                    throw new ParseException("Alpha-Numeric identifier expected, but found period.", this.versionString, (Position)this.input.current());
                }
                if (((Char)this.input.current()).isEndOfInput()) {
                    throw new ParseException("Alpha-Numeric identifier expected, but found end of input.", this.versionString, (Position)this.input.current());
                }
            }
            sb.append(consumed.getValue());
        } while (((Char)this.input.current()).isAlphaNumeric() || ((Char)this.input.current()).is('.'));
        return new BuildMetadata(sb.toString());
    }

    private String consumeNumber() throws ParseException {
        StringBuilder sb = new StringBuilder();
        if (!((Char)this.input.current()).isDigit()) {
            throw new ParseException("Numeric identifier expected.", this.versionString, (Position)this.input.current());
        }
        if (((Char)this.input.current()).is('0') && ((Char)this.input.next()).isDigit()) {
            throw new ParseException("Numeric identifier must not contain leading zeros.", this.versionString, (Position)this.input.current());
        }
        do {
            sb.append(((Char)this.input.consume()).getValue());
        } while (((Char)this.input.current()).isDigit());
        return sb.toString();
    }

    private boolean lookaheadAlphaNumeric() throws ParseException {
        boolean foundNonDigit = false;
        int i = 0;
        while (!foundNonDigit) {
            boolean bl = foundNonDigit = ((Char)this.input.next(i)).isLetter() || ((Char)this.input.next(i)).is('-');
            if (!((Char)this.input.next(i)).isAlphaNumeric()) {
                return foundNonDigit;
            }
            ++i;
        }
        return true;
    }

    private String consumeAlphaNumeric() throws ParseException {
        StringBuilder sb = new StringBuilder();
        if (!((Char)this.input.current()).isAlphaNumeric()) {
            throw new ParseException("Alpha-Numeric identifier expected.", this.versionString, (Position)this.input.current());
        }
        do {
            sb.append(((Char)this.input.consume()).getValue());
        } while (((Char)this.input.current()).isAlphaNumeric());
        return sb.toString();
    }

    private void consumeCharacter(char expected) throws ParseException {
        if (!((Char)this.input.current()).is(expected)) {
            throw new ParseException(String.format("Illegal character. Character '%s' expected.", Character.valueOf(expected)), this.versionString, (Position)this.input.current());
        }
        this.input.consume();
    }
}

