/*
 * Decompiled with CFR 0.152.
 */
package com.hyerodrimm.horsearmorstandmod.entity.custom;

import com.hyerodrimm.horsearmorstandmod.entity.ModEntities;
import com.hyerodrimm.horsearmorstandmod.item.ModItems;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4059;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HorseArmorStandEntity
extends class_1309
implements GeoEntity {
    protected static final RawAnimation SWAY_ANIMATION = RawAnimation.begin().then("animation.horsearmorstand.sway", Animation.LoopType.PLAY_ONCE);
    private boolean playSwayAnimation = false;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final class_4048 MARKER_DIMENSIONS = new class_4048(0.0f, 0.0f, true);
    private static final class_4048 SMALL_DIMENSIONS = ModEntities.HORSE_ARMOR_STAND.method_18386().method_18383(0.5f);
    public static final int SMALL_FLAG = 1;
    public static final int HIDE_BASE_PLATE_FLAG = 8;
    public static final int MARKER_FLAG = 16;
    public static final class_2940<Byte> HORSE_ARMOR_STAND_FLAGS = class_2945.method_12791(HorseArmorStandEntity.class, (class_2941)class_2943.field_13319);
    private static final Predicate<class_1297> RIDEABLE_MINECART_PREDICATE = entity -> entity instanceof class_1688 && ((class_1688)entity).method_7518() == class_1688.class_1689.field_7674;
    private final class_2371<class_1799> armorItems = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private boolean invisible;
    public long lastHitTime;
    private int disabledSlots;

    public HorseArmorStandEntity(class_1299<? extends HorseArmorStandEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(0.0f);
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    private boolean canClip() {
        return !this.isMarker() && !this.method_5740();
    }

    public boolean method_6034() {
        return super.method_6034() && this.canClip();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HORSE_ARMOR_STAND_FLAGS, (Object)0);
    }

    public Iterable<class_1799> method_5661() {
        return this.armorItems;
    }

    public class_1799 getArmorType() {
        return this.method_6118(class_1304.field_6174);
    }

    public class_1799 method_6118(class_1304 slot) {
        switch (slot.method_5925()) {
            case field_6178: {
                return (class_1799)this.armorItems.get(slot.method_5927());
            }
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        this.method_37410(stack);
        switch (slot.method_5925()) {
            case field_6178: {
                this.method_6116(slot, (class_1799)this.armorItems.set(slot.method_5927(), (Object)stack), stack);
            }
        }
    }

    public boolean method_18397(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909() instanceof class_4059 && this.getArmorType().method_7960() && !this.isSlotDisabled(class_1304.field_6174);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2499 nbtList = new class_2499();
        for (class_1799 itemStack : this.armorItems) {
            class_2487 nbtCompound = new class_2487();
            if (!itemStack.method_7960()) {
                itemStack.method_7953(nbtCompound);
            }
            nbtList.add((Object)nbtCompound);
        }
        nbt.method_10566("ArmorItems", (class_2520)nbtList);
        nbt.method_10556("Invisible", this.method_5767());
        nbt.method_10556("Small", this.isSmall());
        nbt.method_10569("DisabledSlots", this.disabledSlots);
        nbt.method_10556("NoBasePlate", this.shouldHideBasePlate());
        if (this.isMarker()) {
            nbt.method_10556("Marker", this.isMarker());
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("ArmorItems", 9)) {
            class_2499 nbtList = nbt.method_10554("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)class_1799.method_7915((class_2487)nbtList.method_10602(i)));
            }
        }
        this.method_5648(nbt.method_10577("Invisible"));
        this.setSmall(nbt.method_10577("Small"));
        this.disabledSlots = nbt.method_10550("DisabledSlots");
        this.setHideBasePlate(nbt.method_10577("NoBasePlate"));
        this.setMarker(nbt.method_10577("Marker"));
        this.field_5960 = !this.canClip();
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829(), RIDEABLE_MINECART_PREDICATE);
        for (int i = 0; i < list.size(); ++i) {
            class_1297 entity = (class_1297)list.get(i);
            if (!(this.method_5858(entity) <= 0.2)) continue;
            entity.method_5697((class_1297)this);
        }
    }

    public class_1269 method_5664(class_1657 player, class_243 hitPos, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isMarker() || itemStack.method_31574(class_1802.field_8448)) {
            return class_1269.field_5811;
        }
        if (player.method_7325()) {
            return class_1269.field_5812;
        }
        if (player.method_37908().field_9236) {
            return class_1269.field_21466;
        }
        if (itemStack.method_7960()) {
            if (this.method_6084(class_1304.field_6174) && this.equip(player, class_1304.field_6174, itemStack, hand)) {
                return class_1269.field_5812;
            }
        } else if (itemStack.method_7909() instanceof class_4059 && !this.isSlotDisabled(class_1304.field_6174)) {
            if (this.isSlotDisabled(class_1304.field_6174)) {
                return class_1269.field_5814;
            }
            if (this.equip(player, class_1304.field_6174, itemStack, hand)) {
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private boolean isSlotDisabled(class_1304 slot) {
        return (this.disabledSlots & 1 << slot.method_5926()) != 0;
    }

    private boolean equip(class_1657 player, class_1304 slot, class_1799 stack, class_1268 hand) {
        class_1799 itemStack = this.method_6118(slot);
        if (!itemStack.method_7960() && (this.disabledSlots & 1 << slot.method_5926() + 8) != 0) {
            return false;
        }
        if (itemStack.method_7960() && (this.disabledSlots & 1 << slot.method_5926() + 16) != 0) {
            return false;
        }
        if (player.method_31549().field_7477 && itemStack.method_7960() && !stack.method_7960()) {
            this.method_5673(slot, stack.method_46651(1));
            return true;
        }
        if (!stack.method_7960() && stack.method_7947() > 1) {
            if (!itemStack.method_7960()) {
                return false;
            }
            this.method_5673(slot, stack.method_7971(1));
            return true;
        }
        this.method_5673(slot, stack);
        player.method_6122(hand, itemStack);
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().field_9236 || this.method_31481()) {
            return false;
        }
        if (source.method_48789(class_8103.field_42242)) {
            this.method_5768();
            return false;
        }
        if (this.method_5679(source) || this.invisible || this.isMarker()) {
            return false;
        }
        if (source.method_48789(class_8103.field_42249)) {
            this.onBreak(source);
            this.method_5768();
            return false;
        }
        if (source.method_48789(class_8103.field_42258)) {
            if (this.method_5809()) {
                this.updateHealth(source, 0.15f);
            } else {
                this.method_5639(5);
            }
            return false;
        }
        if (source.method_48789(class_8103.field_42259) && this.method_6032() > 0.5f) {
            this.updateHealth(source, 4.0f);
            return false;
        }
        boolean bl = source.method_5526() instanceof class_1665;
        boolean bl2 = bl && ((class_1665)source.method_5526()).method_7447() > 0;
        boolean bl3 = "player".equals(source.method_5525());
        if (!bl3 && !bl) {
            return false;
        }
        class_1297 entity = source.method_5529();
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            if (!playerEntity.method_31549().field_7476) {
                return false;
            }
        }
        if (source.method_5530()) {
            this.playBreakSound();
            this.spawnBreakParticles();
            this.method_5768();
            return bl2;
        }
        long l = this.method_37908().method_8510();
        if (l - this.lastHitTime <= 5L || bl) {
            this.breakAndDropItem(source);
            this.spawnBreakParticles();
            this.method_5768();
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)32);
            this.method_32875(class_5712.field_28736, source.method_5529());
            this.lastHitTime = l;
        }
        return true;
    }

    public void method_5711(byte status) {
        if (status == 32) {
            if (this.method_37908().field_9236) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14897, this.method_5634(), 0.3f, 1.0f, false);
                this.lastHitTime = this.method_37908().method_8510();
            }
        } else {
            super.method_5711(status);
        }
    }

    public boolean method_5640(double distance) {
        double d;
        double d2 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d2) || d2 == 0.0) {
            d2 = 4.0;
        }
        return distance < d * (d2 *= 64.0);
    }

    private void spawnBreakParticles() {
        if (this.method_37908() instanceof class_3218) {
            ((class_3218)this.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564()), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    private void updateHealth(class_1282 damageSource, float amount) {
        float f;
        float f2 = this.method_6032();
        f2 -= amount;
        if (f <= 0.5f) {
            this.onBreak(damageSource);
            this.method_5768();
        } else {
            this.method_6033(f2);
            this.method_32875(class_5712.field_28736, damageSource.method_5529());
        }
    }

    private void breakAndDropItem(class_1282 damageSource) {
        class_1799 itemStack = new class_1799((class_1935)ModItems.HORSE_ARMOR_STAND_ITEM);
        if (this.method_16914()) {
            itemStack.method_7977(this.method_5797());
        }
        class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)itemStack);
        this.onBreak(damageSource);
    }

    private void onBreak(class_1282 damageSource) {
        this.playBreakSound();
        this.method_16080(damageSource);
        for (int i = 0; i < this.armorItems.size(); ++i) {
            class_1799 itemStack = (class_1799)this.armorItems.get(i);
            if (itemStack.method_7960()) continue;
            class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515().method_10084(), (class_1799)itemStack);
            this.armorItems.set(i, (Object)class_1799.field_8037);
        }
    }

    private void playBreakSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15118, this.method_5634(), 1.0f, 1.0f);
    }

    protected float method_6031(float bodyRotation, float headRotation) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.method_36454();
        return 0.0f;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * (this.method_6109() ? 0.5f : 0.9f);
    }

    public double method_5678() {
        return this.isMarker() ? 0.0 : (double)0.1f;
    }

    public void method_6091(class_243 movementInput) {
        if (!this.canClip()) {
            return;
        }
        super.method_6091(movementInput);
    }

    public void method_5636(float bodyYaw) {
        this.field_6220 = this.field_5982 = bodyYaw;
        this.field_6259 = this.field_6241 = bodyYaw;
    }

    public void method_5847(float headYaw) {
        this.field_6220 = this.field_5982 = headYaw;
        this.field_6259 = this.field_6241 = headYaw;
    }

    public void method_5773() {
        super.method_5773();
    }

    protected void method_6027() {
        this.method_5648(this.invisible);
    }

    public void method_5648(boolean invisible) {
        this.invisible = invisible;
        super.method_5648(invisible);
    }

    public boolean method_6109() {
        return this.isSmall();
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
        this.method_32876(class_5712.field_37676);
    }

    public boolean method_5659() {
        return this.method_5767();
    }

    public class_3619 method_5657() {
        if (this.isMarker()) {
            return class_3619.field_15975;
        }
        return super.method_5657();
    }

    public boolean method_5696() {
        return this.isMarker();
    }

    private void setSmall(boolean small) {
        this.field_6011.method_12778(HORSE_ARMOR_STAND_FLAGS, (Object)this.setBitField((Byte)this.field_6011.method_12789(HORSE_ARMOR_STAND_FLAGS), 1, small));
    }

    public boolean isSmall() {
        return ((Byte)this.field_6011.method_12789(HORSE_ARMOR_STAND_FLAGS) & 1) != 0;
    }

    public void setHideBasePlate(boolean hideBasePlate) {
        this.field_6011.method_12778(HORSE_ARMOR_STAND_FLAGS, (Object)this.setBitField((Byte)this.field_6011.method_12789(HORSE_ARMOR_STAND_FLAGS), 8, hideBasePlate));
    }

    public boolean shouldHideBasePlate() {
        return ((Byte)this.field_6011.method_12789(HORSE_ARMOR_STAND_FLAGS) & 8) != 0;
    }

    private void setMarker(boolean marker) {
        this.field_6011.method_12778(HORSE_ARMOR_STAND_FLAGS, (Object)this.setBitField((Byte)this.field_6011.method_12789(HORSE_ARMOR_STAND_FLAGS), 16, marker));
    }

    public boolean isMarker() {
        return ((Byte)this.field_6011.method_12789(HORSE_ARMOR_STAND_FLAGS) & 0x10) != 0;
    }

    private byte setBitField(byte value, int bitField, boolean set) {
        value = set ? (byte)(value | bitField) : (byte)(value & ~bitField);
        return value;
    }

    public boolean method_5863() {
        return super.method_5863() && !this.isMarker();
    }

    public boolean method_5698(class_1297 attacker) {
        return attacker instanceof class_1657 && !this.method_37908().method_8505((class_1657)attacker, this.method_24515());
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_15186, class_3417.field_15186);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14897;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15118;
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
    }

    public boolean method_6086() {
        return false;
    }

    public void method_5674(class_2940<?> data) {
        if (HORSE_ARMOR_STAND_FLAGS.equals(data)) {
            this.method_18382();
            this.field_23807 = !this.isMarker();
        }
        super.method_5674(data);
    }

    public boolean method_6102() {
        return false;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.getDimensions(this.isMarker());
    }

    private class_4048 getDimensions(boolean marker) {
        if (marker) {
            return MARKER_DIMENSIONS;
        }
        return this.method_6109() ? SMALL_DIMENSIONS : this.method_5864().method_18386();
    }

    public class_243 method_31166(float tickDelta) {
        if (this.isMarker()) {
            class_238 box = this.getDimensions(false).method_30757(this.method_19538());
            class_2338 blockPos = this.method_24515();
            int i = Integer.MIN_VALUE;
            for (class_2338 blockPos2 : class_2338.method_10097((class_2338)class_2338.method_49637((double)box.field_1323, (double)box.field_1322, (double)box.field_1321), (class_2338)class_2338.method_49637((double)box.field_1320, (double)box.field_1325, (double)box.field_1324))) {
                int j = Math.max(this.method_37908().method_8314(class_1944.field_9282, blockPos2), this.method_37908().method_8314(class_1944.field_9284, blockPos2));
                if (j == 15) {
                    return class_243.method_24953((class_2382)blockPos2);
                }
                if (j <= i) continue;
                i = j;
                blockPos = blockPos2.method_10062();
            }
            return class_243.method_24953((class_2382)blockPos);
        }
        return super.method_31166(tickDelta);
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)ModItems.HORSE_ARMOR_STAND_ITEM);
    }

    public boolean method_36608() {
        return !this.method_5767() && !this.isMarker();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.playSwayAnimation) {
            this.playSwayAnimation = false;
            return tAnimationState.setAndContinue(SWAY_ANIMATION);
        }
        tAnimationState.getController().forceAnimationReset();
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void SetPlaySwayAnimation(boolean b) {
        this.playSwayAnimation = b;
    }
}

