/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class LivingEntityTrinketComponent
implements TrinketComponent,
AutoSyncedComponent {
    public Map<String, Map<String, TrinketInventory>> inventory = new HashMap<String, Map<String, TrinketInventory>>();
    public Set<TrinketInventory> trackingUpdates = new HashSet<TrinketInventory>();
    public Map<String, SlotGroup> groups = new HashMap<String, SlotGroup>();
    public int size;
    public class_1309 entity;
    private boolean syncing;

    public LivingEntityTrinketComponent(class_1309 entity) {
        this.entity = entity;
        this.update();
    }

    @Override
    public class_1309 getEntity() {
        return this.entity;
    }

    @Override
    public Map<String, SlotGroup> getGroups() {
        return this.groups;
    }

    @Override
    public Map<String, Map<String, TrinketInventory>> getInventory() {
        return this.inventory;
    }

    @Override
    public void update() {
        Map<String, SlotGroup> entitySlots = TrinketsApi.getEntitySlots((class_1297)this.entity);
        int count = 0;
        this.groups.clear();
        HashMap<String, Map<String, TrinketInventory>> inventory = new HashMap<String, Map<String, TrinketInventory>>();
        for (Map.Entry<String, SlotGroup> group : entitySlots.entrySet()) {
            String groupKey = group.getKey();
            SlotGroup groupValue = group.getValue();
            Map<String, TrinketInventory> oldGroup = this.inventory.get(groupKey);
            this.groups.put(groupKey, groupValue);
            for (Map.Entry<String, SlotType> slot : groupValue.getSlots().entrySet()) {
                TrinketInventory oldInv;
                TrinketInventory inv = new TrinketInventory(slot.getValue(), this, e -> this.trackingUpdates.add((TrinketInventory)e));
                if (oldGroup != null && (oldInv = oldGroup.get(slot.getKey())) != null) {
                    inv.copyFrom(oldInv);
                    for (int i = 0; i < oldInv.method_5439(); ++i) {
                        class_1799 stack = oldInv.method_5438(i).method_7972();
                        if (i < inv.method_5439()) {
                            inv.method_5447(i, stack);
                            continue;
                        }
                        class_1309 class_13092 = this.entity;
                        if (class_13092 instanceof class_1657) {
                            class_1657 player = (class_1657)class_13092;
                            player.method_31548().method_7398(stack);
                            continue;
                        }
                        this.entity.method_5775(stack);
                    }
                }
                inventory.computeIfAbsent(group.getKey(), k -> new HashMap()).put(slot.getKey(), inv);
                count += inv.method_5439();
            }
        }
        this.size = count;
        this.inventory = inventory;
    }

    @Override
    public void clearCachedModifiers() {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                slotType.getValue().clearCachedModifiers();
            }
        }
    }

    @Override
    public Set<TrinketInventory> getTrackingUpdates() {
        return this.trackingUpdates;
    }

    @Override
    public void addTemporaryModifiers(Multimap<String, class_1322> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (class_1322 modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.addModifier(modifier);
            }
        }
    }

    @Override
    public void addPersistentModifiers(Multimap<String, class_1322> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (class_1322 modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.addPersistentModifier(modifier);
            }
        }
    }

    @Override
    public void removeModifiers(Multimap<String, class_1322> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (class_1322 modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.removeModifier(modifier.method_6189());
            }
        }
    }

    @Override
    public Multimap<String, class_1322> getModifiers() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                result.putAll((Object)(group.getKey() + "/" + slotType.getKey()), slotType.getValue().getModifiers().values());
            }
        }
        return result;
    }

    @Override
    public void clearModifiers() {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                slotType.getValue().clearModifiers();
            }
        }
    }

    public void readFromNbt(class_2487 tag) {
        class_2371 dropped = class_2371.method_10211();
        for (String groupKey : tag.method_10541()) {
            class_2499 list;
            class_2487 slotTag;
            class_2487 groupTag = tag.method_10562(groupKey);
            if (groupTag == null) continue;
            Map<String, TrinketInventory> groupSlots = this.inventory.get(groupKey);
            if (groupSlots != null) {
                for (String slotKey : groupTag.method_10541()) {
                    slotTag = groupTag.method_10562(slotKey);
                    list = slotTag.method_10554("Items", 10);
                    TrinketInventory inv = groupSlots.get(slotKey);
                    if (inv != null) {
                        inv.fromTag(slotTag.method_10562("Metadata"));
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        class_2487 c = list.method_10602(i);
                        class_1799 stack = class_1799.method_7915((class_2487)c);
                        if (inv != null && i < inv.method_5439()) {
                            inv.method_5447(i, stack);
                            continue;
                        }
                        dropped.add((Object)stack);
                    }
                }
                continue;
            }
            for (String slotKey : groupTag.method_10541()) {
                slotTag = groupTag.method_10562(slotKey);
                list = slotTag.method_10554("Items", 10);
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 c = list.method_10602(i);
                    dropped.add((Object)class_1799.method_7915((class_2487)c));
                }
            }
        }
        for (class_1799 itemStack : dropped) {
            this.entity.method_5775(itemStack);
        }
        HashMultimap slotMap = HashMultimap.create();
        this.forEach((arg_0, arg_1) -> this.lambda$readFromNbt$2((Multimap)slotMap, arg_0, arg_1));
        for (Map.Entry<String, Map<String, TrinketInventory>> groupEntry : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotEntry : groupEntry.getValue().entrySet()) {
                String group = groupEntry.getKey();
                String slot = slotEntry.getKey();
                String key = group + "/" + slot;
                Collection modifiers = slotMap.get((Object)key);
                TrinketInventory inventory = slotEntry.getValue();
                for (class_1322 modifier : modifiers) {
                    inventory.removeCachedModifier(modifier);
                }
                inventory.clearCachedModifiers();
            }
        }
    }

    public void applySyncPacket(class_2540 buf) {
        class_2487 tag = buf.method_10798();
        if (tag != null) {
            for (String groupKey : tag.method_10541()) {
                Map<String, TrinketInventory> groupSlots;
                class_2487 groupTag = tag.method_10562(groupKey);
                if (groupTag == null || (groupSlots = this.inventory.get(groupKey)) == null) continue;
                for (String slotKey : groupTag.method_10541()) {
                    class_2487 slotTag = groupTag.method_10562(slotKey);
                    class_2499 list = slotTag.method_10554("Items", 10);
                    TrinketInventory inv = groupSlots.get(slotKey);
                    if (inv != null) {
                        inv.applySyncTag(slotTag.method_10562("Metadata"));
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        class_2487 c = list.method_10602(i);
                        class_1799 stack = class_1799.method_7915((class_2487)c);
                        if (inv == null || i >= inv.method_5439()) continue;
                        inv.method_5447(i, stack);
                    }
                }
            }
            class_1309 class_13092 = this.entity;
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                ((TrinketPlayerScreenHandler)player.field_7498).trinkets$updateTrinketSlots(false);
            }
        }
    }

    public void writeToNbt(class_2487 tag) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            class_2487 groupTag = new class_2487();
            for (Map.Entry<String, TrinketInventory> slot : group.getValue().entrySet()) {
                class_2487 slotTag = new class_2487();
                class_2499 list = new class_2499();
                TrinketInventory inv = slot.getValue();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    class_2487 c = inv.method_5438(i).method_7953(new class_2487());
                    list.add((Object)c);
                }
                slotTag.method_10566("Metadata", (class_2520)(this.syncing ? inv.getSyncTag() : inv.toTag()));
                slotTag.method_10566("Items", (class_2520)list);
                groupTag.method_10566(slot.getKey(), (class_2520)slotTag);
            }
            tag.method_10566(group.getKey(), (class_2520)groupTag);
        }
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        this.syncing = true;
        class_2487 tag = new class_2487();
        this.writeToNbt(tag);
        this.syncing = false;
        buf.method_10794(tag);
    }

    @Override
    public boolean isEquipped(Predicate<class_1799> predicate) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                TrinketInventory inv = slotType.getValue();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    if (!predicate.test(inv.method_5438(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<class_3545<SlotReference, class_1799>> getEquipped(Predicate<class_1799> predicate) {
        ArrayList<class_3545<SlotReference, class_1799>> list = new ArrayList<class_3545<SlotReference, class_1799>>();
        this.forEach((slotReference, itemStack) -> {
            if (predicate.test((class_1799)itemStack)) {
                list.add(new class_3545(slotReference, itemStack));
            }
        });
        return list;
    }

    @Override
    public void forEach(BiConsumer<SlotReference, class_1799> consumer) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                TrinketInventory inv = slotType.getValue();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    consumer.accept(new SlotReference(inv, i), inv.method_5438(i));
                }
            }
        }
    }

    private /* synthetic */ void lambda$readFromNbt$2(Multimap slotMap, SlotReference ref, class_1799 stack) {
        if (!stack.method_7960()) {
            UUID uuid = SlotAttributes.getUuid(ref);
            Trinket trinket = TrinketsApi.getTrinket(stack.method_7909());
            Multimap<class_1320, class_1322> map = trinket.getModifiers(stack, ref, this.entity, uuid);
            for (class_1320 entityAttribute : map.keySet()) {
                if (!(entityAttribute instanceof SlotAttributes.SlotEntityAttribute)) continue;
                SlotAttributes.SlotEntityAttribute slotEntityAttribute = (SlotAttributes.SlotEntityAttribute)entityAttribute;
                slotMap.putAll((Object)slotEntityAttribute.slot, (Iterable)map.get((Object)entityAttribute));
            }
        }
    }
}

