/*
 * Decompiled with CFR 0.152.
 */
package com.helliongames.evoodooers.entity.block;

import com.google.common.collect.Iterables;
import com.helliongames.evoodooers.registration.EvoodooersBlockEntities;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3312;
import net.minecraft.class_3544;
import net.minecraft.class_7497;
import org.jetbrains.annotations.Nullable;

public class VoodooDollBlockEntity
extends class_2586 {
    public static final String TAG_CONNECTED_PLAYER = "ConnectedPlayer";
    public static final String TAG_UNBOUND_PLAYER = "UnboundPlayer";
    @Nullable
    private static class_3312 profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;
    @Nullable
    private GameProfile owner;
    @Nullable
    private GameProfile unboundPlayer;

    public VoodooDollBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public VoodooDollBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(EvoodooersBlockEntities.VOODOO_DOLL.get(), blockPos, blockState);
    }

    public static void setup(class_7497 services, Executor executor) {
        profileCache = services.comp_840();
        sessionService = services.comp_837();
        mainThreadExecutor = executor;
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }

    protected void method_11007(class_2487 tag) {
        class_2487 compoundTag2;
        super.method_11007(tag);
        if (this.owner != null) {
            compoundTag2 = new class_2487();
            class_2512.method_10684((class_2487)compoundTag2, (GameProfile)this.owner);
            tag.method_10566(TAG_CONNECTED_PLAYER, (class_2520)compoundTag2);
        }
        if (this.unboundPlayer != null) {
            compoundTag2 = new class_2487();
            class_2512.method_10684((class_2487)compoundTag2, (GameProfile)this.unboundPlayer);
            tag.method_10566(TAG_UNBOUND_PLAYER, (class_2520)compoundTag2);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573(TAG_CONNECTED_PLAYER, 10)) {
            this.setOwner(class_2512.method_10683((class_2487)tag.method_10562(TAG_CONNECTED_PLAYER)));
        }
        if (tag.method_10573(TAG_UNBOUND_PLAYER, 10)) {
            this.setUnboundPlayer(class_2512.method_10683((class_2487)tag.method_10562(TAG_UNBOUND_PLAYER)));
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public GameProfile getOwnerProfile() {
        return this.owner;
    }

    @Nullable
    public GameProfile getUnboundProfile() {
        return this.unboundPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile profile) {
        VoodooDollBlockEntity voodooDollBlockEntity = this;
        synchronized (voodooDollBlockEntity) {
            this.owner = profile;
        }
        this.updateOwnerProfile();
        if (this.owner != null) {
            this.unboundPlayer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnboundPlayer(@Nullable GameProfile profile) {
        VoodooDollBlockEntity voodooDollBlockEntity = this;
        synchronized (voodooDollBlockEntity) {
            this.unboundPlayer = profile;
        }
        this.updateUnboundProfile();
    }

    private void updateOwnerProfile() {
        VoodooDollBlockEntity.updateGameprofile(this.owner, profile -> {
            this.owner = profile;
            this.method_5431();
        });
    }

    private void updateUnboundProfile() {
        VoodooDollBlockEntity.updateGameprofile(this.unboundPlayer, profile -> {
            this.unboundPlayer = profile;
            this.method_5431();
        });
    }

    public static void updateGameprofile(@Nullable GameProfile gameProfile, Consumer<GameProfile> profileConsumer) {
        if (!(gameProfile == null || class_3544.method_15438((String)gameProfile.getName()) || gameProfile.isComplete() && gameProfile.getProperties().containsKey((Object)"textures") || profileCache == null || sessionService == null)) {
            profileCache.method_37156(gameProfile.getName(), p_182470_ -> class_156.method_18349().execute(() -> class_156.method_17974((Optional)p_182470_, p_276255_ -> {
                Property property = (Property)Iterables.getFirst((Iterable)p_276255_.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    MinecraftSessionService minecraftsessionservice = sessionService;
                    if (minecraftsessionservice == null) {
                        return;
                    }
                    p_276255_ = minecraftsessionservice.fillProfileProperties(p_276255_, true);
                }
                GameProfile gameprofile = p_276255_;
                Executor executor = mainThreadExecutor;
                if (executor != null) {
                    executor.execute(() -> {
                        class_3312 gameprofilecache = profileCache;
                        if (gameprofilecache != null) {
                            gameprofilecache.method_14508(gameprofile);
                            profileConsumer.accept(gameprofile);
                        }
                    });
                }
            }, () -> {
                Executor executor = mainThreadExecutor;
                if (executor != null) {
                    executor.execute(() -> profileConsumer.accept(gameProfile));
                }
            })));
        } else {
            profileConsumer.accept(gameProfile);
        }
    }
}

