/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.platform;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.SeasonHUDClient;
import club.iananderson.seasonhud.platform.services.ISeasonHelper;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasonsextras.FabricSeasonsExtras;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;

public class FabricSeasonHelper
implements ISeasonHelper {
    @Override
    public boolean isTropicalSeason() {
        return false;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        return FabricSeasons.CONFIG.isSeasonTiedWithSystemTime();
    }

    @Override
    public String getCurrentSeasonState() {
        String seasonState = FabricSeasons.getCurrentSeason((class_1937)((class_1937)Objects.requireNonNull(SeasonHUDClient.mc.field_1687))).toString();
        if (seasonState.equalsIgnoreCase("fall")) {
            return "Autumn";
        }
        return seasonState;
    }

    @Override
    public String getSeasonFileName() {
        return this.getCurrentSeasonState().toLowerCase();
    }

    @Override
    public int getDate() {
        if (this.isSeasonTiedWithSystemTime()) {
            return LocalDateTime.now().getDayOfMonth();
        }
        int seasonLength = FabricSeasons.CONFIG.getSpringLength();
        int worldTime = Math.toIntExact(Objects.requireNonNull(SeasonHUDClient.mc.field_1687).method_8532());
        return (worldTime - worldTime / seasonLength * seasonLength) % seasonLength / 24000 + 1;
    }

    @Override
    public int seasonDuration() {
        return FabricSeasons.CONFIG.getSpringLength() / 24000;
    }

    @Override
    public class_1792 calendar() {
        if (Common.extrasLoaded()) {
            return FabricSeasonsExtras.SEASON_CALENDAR_ITEM;
        }
        return null;
    }

    @Override
    public int findCuriosCalendar(class_1657 player, class_1792 item) {
        if (Common.curiosLoaded() && Common.extrasLoaded()) {
            Optional findCalendar = TrinketsApi.getTrinketComponent((class_1309)player);
            if (findCalendar.isPresent()) {
                if (((TrinketComponent)findCalendar.get()).isEquipped(item)) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }
}

