/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.Config;
import club.iananderson.seasonhud.config.ShowDay;
import club.iananderson.seasonhud.impl.seasons.SeasonList;
import club.iananderson.seasonhud.platform.Services;
import java.time.LocalDateTime;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class CurrentSeason {
    public static String getSeasonStateLower() {
        return Services.SEASON.getCurrentSeasonState().toLowerCase();
    }

    public static String getSeasonIcon(String seasonFileName) {
        for (SeasonList season : SeasonList.values()) {
            if (!season.getFileName().equals(seasonFileName)) continue;
            return season.getIconChar();
        }
        return null;
    }

    public static int getTextColor(String seasonFileName) {
        for (SeasonList season : SeasonList.values()) {
            if (!season.getFileName().equals(seasonFileName)) continue;
            return season.getSeasonColor();
        }
        return 0xFFFFFF;
    }

    public static ArrayList<class_2561> getSeasonHudName() {
        ArrayList<class_2561> text = new ArrayList<class_2561>();
        ShowDay showDay = (ShowDay)((Object)Config.showDay.get());
        String fileName = Services.SEASON.getSeasonFileName();
        class_2583 SEASON_FORMAT = class_2583.field_24360;
        if (((Boolean)Config.enableSeasonNameColor.get()).booleanValue()) {
            SEASON_FORMAT = class_2583.field_24360.method_36139(CurrentSeason.getTextColor(fileName));
        }
        switch (showDay) {
            case NONE: {
                text.add((class_2561)class_2561.method_43469((String)"desc.seasonhud.icon", (Object[])new Object[]{CurrentSeason.getSeasonIcon(fileName)}).method_27696(Common.SEASON_STYLE));
                text.add((class_2561)class_2561.method_43469((String)"desc.seasonhud.summary", (Object[])new Object[]{class_2561.method_43471((String)("desc.seasonhud." + CurrentSeason.getSeasonStateLower()))}).method_27696(SEASON_FORMAT));
                break;
            }
            case SHOW_DAY: {
                text.add((class_2561)class_2561.method_43469((String)"desc.seasonhud.icon", (Object[])new Object[]{CurrentSeason.getSeasonIcon(fileName)}).method_27696(Common.SEASON_STYLE));
                text.add((class_2561)class_2561.method_43469((String)"desc.seasonhud.detailed", (Object[])new Object[]{class_2561.method_43471((String)("desc.seasonhud." + CurrentSeason.getSeasonStateLower())), Services.SEASON.getDate()}).method_27696(SEASON_FORMAT));
                break;
            }
            case SHOW_WITH_TOTAL_DAYS: {
                text.add((class_2561)class_2561.method_43469((String)"desc.seasonhud.icon", (Object[])new Object[]{CurrentSeason.getSeasonIcon(fileName)}).method_27696(Common.SEASON_STYLE));
                text.add((class_2561)class_2561.method_43469((String)"desc.seasonhud.detailed.total", (Object[])new Object[]{class_2561.method_43471((String)("desc.seasonhud." + CurrentSeason.getSeasonStateLower())), Services.SEASON.getDate(), Services.SEASON.seasonDuration()}).method_27696(SEASON_FORMAT));
                break;
            }
            case SHOW_WITH_MONTH: {
                text.add((class_2561)class_2561.method_43469((String)"desc.seasonhud.icon", (Object[])new Object[]{CurrentSeason.getSeasonIcon(fileName)}).method_27696(Common.SEASON_STYLE));
                if (Services.SEASON.isSeasonTiedWithSystemTime()) {
                    String currentMonth = LocalDateTime.now().getMonth().name().toLowerCase();
                    text.add((class_2561)class_2561.method_43469((String)"desc.seasonhud.month", (Object[])new Object[]{class_2561.method_43471((String)("desc.seasonhud." + CurrentSeason.getSeasonStateLower())), class_2561.method_43471((String)("desc.seasonhud." + currentMonth)), Services.SEASON.getDate()}).method_27696(SEASON_FORMAT));
                    break;
                }
                text.add((class_2561)class_2561.method_43469((String)"desc.seasonhud.detailed", (Object[])new Object[]{class_2561.method_43471((String)("desc.seasonhud." + CurrentSeason.getSeasonStateLower())), Services.SEASON.getDate()}).method_27696(SEASON_FORMAT));
            }
        }
        return text;
    }
}

