/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.config;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.Location;
import club.iananderson.seasonhud.config.ShowDay;
import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.BooleanValue enableMod;
    public static ForgeConfigSpec.ConfigValue<Location> hudLocation;
    public static ForgeConfigSpec.ConfigValue<Integer> hudX;
    public static ForgeConfigSpec.ConfigValue<Integer> hudY;
    public static ForgeConfigSpec.BooleanValue enableSeasonNameColor;
    public static ForgeConfigSpec.ConfigValue<Integer> springColor;
    public static ForgeConfigSpec.ConfigValue<Integer> summerColor;
    public static ForgeConfigSpec.ConfigValue<Integer> autumnColor;
    public static ForgeConfigSpec.ConfigValue<Integer> winterColor;
    public static ForgeConfigSpec.ConfigValue<Integer> dryColor;
    public static ForgeConfigSpec.ConfigValue<Integer> wetColor;
    public static ForgeConfigSpec.BooleanValue needCalendar;
    public static ForgeConfigSpec.BooleanValue showTropicalSeason;
    public static ForgeConfigSpec.BooleanValue showSubSeason;
    public static ForgeConfigSpec.ConfigValue<ShowDay> showDay;
    public static ForgeConfigSpec.BooleanValue enableMinimapIntegration;
    public static ForgeConfigSpec.BooleanValue showDefaultWhenMinimapHidden;
    public static ForgeConfigSpec.BooleanValue journeyMapAboveMap;
    public static ForgeConfigSpec.BooleanValue journeyMapMacOS;

    private static void setupConfig(ForgeConfigSpec.Builder BUILDER) {
        BUILDER.push("SeasonHUD");
        enableMod = BUILDER.comment("Enable the mod?\n(true/false)\nDefault is true.").define("enable_mod", true);
        BUILDER.push("HUD");
        hudLocation = BUILDER.comment("Part of the screen to display the HUD when no minimap is installed\nDefault is \"TOP_LEFT\".").defineEnum("hud_location", (Enum)Location.TOP_LEFT);
        hudX = BUILDER.comment("The horizontal offset of the HUD when no minimap is installed (in pixels)\nDefault is 0.").define("hud_x_position", (Object)0);
        hudY = BUILDER.comment("The vertical offset of the HUD when no minimap is installed (in pixels)\nDefault is 0.").define("hud_y_position", (Object)0);
        BUILDER.push("Colors");
        enableSeasonNameColor = BUILDER.comment("Display the season name in a color?\n(true/false)").define("season_name_color", true);
        springColor = BUILDER.comment("The RGB color (decimal) for spring.\n(256 * 256 * r) + (256 * g) + (b) is the formula\nDefault is 16753595.").defineInRange("spring_color", 16753595, 0, 0xFFFFFF);
        summerColor = BUILDER.comment("The RGB color (decimal) for summer.\n(256 * 256 * r) + (256 * g) + (b) is the formula\nDefault is 16705834.").defineInRange("summer_color", 16705834, 0, 0xFFFFFF);
        autumnColor = BUILDER.comment("The RGB color (decimal) for autumn.\n(256 * 256 * r) + (256 * g) + (b) is the formula\nDefault is 12344871.").defineInRange("autumn_color", 12344871, 0, 0xFFFFFF);
        winterColor = BUILDER.comment("The RGB color (decimal) for winter.\n(256 * 256 * r) + (256 * g) + (b) is the formula\nDefault is 14679292.").defineInRange("winter_color", 0xDFFCFC, 0, 0xFFFFFF);
        dryColor = BUILDER.comment("The RGB color (decimal) for dry tropical season.\n(256 * 256 * r) + (256 * g) + (b) is the formula\nDefault is 16745216.").defineInRange("dry_color", 16745216, 0, 0xFFFFFF);
        wetColor = BUILDER.comment("The RGB color (decimal) for wet tropical season.\n(256 * 256 * r) + (256 * g) + (b) is the formula\nDefault is 2068975.").defineInRange("wet_color", 2068975, 0, 0xFFFFFF);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Season");
        needCalendar = BUILDER.comment("Require the Calendar item to be in the players inventory to show the HUD?\n(true/false)\nDefault is false.").define("need_calendar", false);
        showTropicalSeason = BUILDER.comment("Show the Tropical seasons (Wet/Dry) in Tropical Biomes.\nWill not change the season behavior in the biomes.\n(true/false)\nDefault is true.").define("enable_show_tropical_season", true);
        showSubSeason = BUILDER.comment("Show sub-season (i.e. Early Winter, Mid Autumn, Late Spring) instead of basic season?\n(true/false)\nDefault is true.").define("enable_show_sub_season", true);
        if (Common.platformName().equals("Forge")) {
            showDay = BUILDER.comment("Show the current day of the season/sub-season?\nDefault is SHOW_DAY.").defineEnum("enable_show_day", (Enum)ShowDay.SHOW_DAY, Arrays.asList(ShowDay.NONE, ShowDay.SHOW_DAY, ShowDay.SHOW_WITH_TOTAL_DAYS));
        }
        if (Common.platformName().equals("Fabric")) {
            showDay = BUILDER.comment("Show the current day of the season/sub-season?\nDefault is SHOW_DAY.").defineEnum("enable_show_day", (Enum)ShowDay.SHOW_DAY, Arrays.asList(ShowDay.NONE, ShowDay.SHOW_DAY, ShowDay.SHOW_WITH_TOTAL_DAYS, ShowDay.SHOW_WITH_MONTH));
        }
        BUILDER.pop();
        BUILDER.push("Minimap");
        enableMinimapIntegration = BUILDER.comment("Enable integration with minimap mods.\n(true/false)\nDefault is true.").define("enable_minimap_integration", true);
        showDefaultWhenMinimapHidden = BUILDER.comment("Show the default SeasonHUD display when the minimap is hidden.\n(true/false)\nDefault is false.").define("enable_show_minimap_hidden", false);
        BUILDER.push("Journeymap");
        journeyMapAboveMap = BUILDER.comment("Show above the JourneyMap minimap, instead of below.\n(true/false)\nDefault is false.").define("enable_above_map", false);
        journeyMapMacOS = BUILDER.comment("Toggle for macOS retina display scaling when using JourneyMap.\nEnable if the season line is rendering around the halfway point of the screen.\n(true/false)\nDefault is false.").define("enable_macOS", false);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.pop();
    }

    public static boolean getEnableMod() {
        return (Boolean)enableMod.get();
    }

    public static void setEnableMod(boolean enable) {
        enableMod.set((Object)enable);
    }

    public static void setHudLocation(Location location) {
        hudLocation.set((Object)location);
    }

    public static void setHudX(int x) {
        hudX.set((Object)x);
    }

    public static void setHudY(int y) {
        hudY.set((Object)y);
    }

    public static void setEnableSeasonNameColor(boolean enable) {
        enableSeasonNameColor.set((Object)enable);
    }

    public static int getSpringColor() {
        return (Integer)springColor.get();
    }

    public static void setSpringColor(int rgbColor) {
        springColor.set((Object)rgbColor);
    }

    public static int getSummerColor() {
        return (Integer)summerColor.get();
    }

    public static void setSummerColor(int rgbColor) {
        summerColor.set((Object)rgbColor);
    }

    public static int getAutumnColor() {
        return (Integer)autumnColor.get();
    }

    public static void setAutumnColor(int rgbColor) {
        autumnColor.set((Object)rgbColor);
    }

    public static int getWinterColor() {
        return (Integer)winterColor.get();
    }

    public static void setWinterColor(int rgbColor) {
        winterColor.set((Object)rgbColor);
    }

    public static int getDryColor() {
        return (Integer)dryColor.get();
    }

    public static void setDryColor(int rgbColor) {
        dryColor.set((Object)rgbColor);
    }

    public static int getWetColor() {
        return (Integer)wetColor.get();
    }

    public static void setWetColor(int rgbColor) {
        wetColor.set((Object)rgbColor);
    }

    public static void setNeedCalendar(boolean enable) {
        needCalendar.set((Object)enable);
    }

    public static void setShowTropicalSeason(boolean enable) {
        showTropicalSeason.set((Object)enable);
    }

    public static void setShowSubSeason(boolean enable) {
        showSubSeason.set((Object)enable);
    }

    public static void setShowDay(ShowDay showDay) {
        Config.showDay.set((Object)showDay);
    }

    public static void setEnableMinimapIntegration(boolean enable) {
        enableMinimapIntegration.set((Object)enable);
    }

    public static void setShowDefaultWhenMinimapHidden(boolean enable) {
        showDefaultWhenMinimapHidden.set((Object)enable);
    }

    public static void setJourneyMapAboveMap(boolean enable) {
        journeyMapAboveMap.set((Object)enable);
    }

    public static void setJourneyMapMacOS(boolean enable) {
        journeyMapMacOS.set((Object)enable);
    }

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        Config.setupConfig(BUILDER);
        GENERAL_SPEC = BUILDER.build();
    }
}

