/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.client.SeasonHUDClient;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.client.gui.components.buttons.DefaultColorButton;
import club.iananderson.seasonhud.client.gui.components.buttons.MenuButton;
import club.iananderson.seasonhud.client.gui.components.sliders.BlueSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.GreenSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.RedSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.RgbSlider;
import club.iananderson.seasonhud.client.gui.screens.SeasonHUDScreen;
import club.iananderson.seasonhud.config.Config;
import club.iananderson.seasonhud.impl.seasons.SeasonList;
import club.iananderson.seasonhud.platform.Services;
import club.iananderson.seasonhud.util.Rgb;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import org.jetbrains.annotations.NotNull;

public class ColorScreen
extends class_437 {
    public static final int WIDGET_PADDING = 6;
    private static final int MENU_PADDING_FULL = 25;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final class_2561 TITLE = class_2561.method_43471((String)"menu.seasonhud.color.title");
    private static final class_2561 ENABLE_SEASON_NAME_COLOR = class_2561.method_43471((String)"menu.seasonhud.color.button.enableSeasonNameColor");
    private static final ColorScreen instance = new ColorScreen(SeasonHUDScreen.getInstance());
    public static MenuButton doneButton;
    private final class_437 lastScreen;
    private final List<ColorEditBox> seasonBoxes = new ArrayList<ColorEditBox>();
    private final List<class_339> widgets = new ArrayList<class_339>();
    private MenuButton cancelButton;
    private class_5676<Boolean> seasonNameColorButton;
    private int x;
    private int y;

    public ColorScreen(class_437 screen) {
        super(TITLE);
        this.lastScreen = screen;
        this.widgets.toArray().clone();
    }

    public static void open(class_437 screen) {
        SeasonHUDClient.mc.method_1507((class_437)new ColorScreen(screen));
    }

    private static EnumSet<SeasonList> seasonListSet() {
        Object set = SeasonList.seasons.clone();
        if (!((Boolean)Config.showTropicalSeason.get()).booleanValue() || !Services.PLATFORM.getPlatformName().equals("Forge")) {
            ((AbstractCollection)set).remove((Object)SeasonList.DRY);
            ((AbstractCollection)set).remove((Object)SeasonList.WET);
        }
        return set;
    }

    public boolean method_25421() {
        return true;
    }

    public int getWidth() {
        return SeasonHUDClient.mc.method_22683().method_4486();
    }

    public int getHeight() {
        return SeasonHUDClient.mc.method_22683().method_4502();
    }

    public void method_25393() {
        this.seasonBoxes.forEach(class_342::method_1865);
        super.method_25393();
    }

    private void onDone() {
        this.seasonBoxes.forEach(seasonBoxes -> {
            if (Integer.parseInt(seasonBoxes.method_1882()) != seasonBoxes.getColor()) {
                seasonBoxes.save();
            }
        });
        SeasonHUDClient.mc.method_1507(this.lastScreen);
    }

    private void onCancel() {
        SeasonHUDClient.mc.method_1507(this.lastScreen);
    }

    public int getBoxWidth() {
        int widgetCount = ColorScreen.seasonListSet().size();
        int widgetTotalSize = 86 * widgetCount;
        int scaledWidth = this.getWidth();
        int boxWidth = scaledWidth < widgetTotalSize ? 60 : 80;
        return boxWidth;
    }

    private List<class_339> seasonWidget(int x, int y, SeasonList season) {
        ArrayList<class_339> seasonWidgetList = new ArrayList<class_339>();
        ColorEditBox colorBox = new ColorEditBox(this.field_22793, x, y, this.getBoxWidth(), 20, season);
        this.seasonBoxes.add(colorBox);
        seasonWidgetList.add((class_339)colorBox);
        y += colorBox.method_25364() + 6;
        RedSlider redSlider = new RedSlider(--x, y += 20 + RgbSlider.SLIDER_PADDING, colorBox);
        seasonWidgetList.add((class_339)redSlider);
        GreenSlider greenSlider = new GreenSlider(x, y += redSlider.method_25364() + RgbSlider.SLIDER_PADDING, colorBox);
        seasonWidgetList.add((class_339)greenSlider);
        BlueSlider blueSlider = new BlueSlider(x, y += greenSlider.method_25364() + RgbSlider.SLIDER_PADDING, colorBox);
        seasonWidgetList.add((class_339)blueSlider);
        seasonWidgetList.add((class_339)new DefaultColorButton(x, y -= greenSlider.method_25364() + redSlider.method_25364() + RgbSlider.SLIDER_PADDING + 20 + RgbSlider.SLIDER_PADDING, season, colorBox, button -> {
            int defaultColorInt = season.getDefaultColor();
            if (colorBox.getNewColor() != defaultColorInt) {
                redSlider.setSliderValue(defaultColorInt);
                greenSlider.setSliderValue(defaultColorInt);
                blueSlider.setSliderValue(defaultColorInt);
                colorBox.method_1852(String.valueOf(defaultColorInt));
                Rgb.setRgb(season, defaultColorInt);
            }
        }));
        return seasonWidgetList;
    }

    public void method_25426() {
        this.widgets.clear();
        int scaledWidth = this.getWidth();
        int leftButtonX = this.getWidth() / 2 - 156;
        int rightButtonX = this.getWidth() / 2 + 6;
        int widgetWidth = this.getBoxWidth() + 6;
        int totalWidgetWidth = ColorScreen.seasonListSet().size() * widgetWidth - 6;
        this.x = scaledWidth / 2 - totalWidgetWidth / 2;
        this.y = 71;
        ColorScreen.seasonListSet().forEach(season -> {
            this.widgets.addAll(this.seasonWidget(this.x, this.y, (SeasonList)((Object)season)));
            this.x += widgetWidth;
        });
        this.seasonNameColorButton = class_5676.method_32613((boolean)((Boolean)Config.enableSeasonNameColor.get())).method_32617(leftButtonX, 25, 150, 20, ENABLE_SEASON_NAME_COLOR, (b, enableColor) -> Config.setEnableSeasonNameColor(enableColor));
        this.widgets.add((class_339)this.seasonNameColorButton);
        doneButton = new MenuButton(leftButtonX, this.getHeight() - 20 - 6, MenuButton.MenuButtons.DONE, press -> this.onDone());
        this.widgets.add((class_339)doneButton);
        this.cancelButton = new MenuButton(rightButtonX, this.getHeight() - 20 - 6, MenuButton.MenuButtons.CANCEL, press -> this.onCancel());
        this.widgets.add((class_339)this.cancelButton);
        this.widgets.forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, TITLE, this.getWidth() / 2, 6, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }
}

