/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.boxes;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.SeasonHUDClient;
import club.iananderson.seasonhud.client.gui.screens.ColorScreen;
import club.iananderson.seasonhud.config.Config;
import club.iananderson.seasonhud.impl.seasons.SeasonList;
import club.iananderson.seasonhud.platform.Services;
import club.iananderson.seasonhud.util.Rgb;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class ColorEditBox
extends class_342 {
    private static final int PADDING = 4;
    private final SeasonList boxSeason;
    private final int seasonColor;
    private int newSeasonColor;

    public ColorEditBox(class_327 font, int x, int y, int width, int height, SeasonList season) {
        super(font, x, y, width, height, season.getSeasonName());
        this.boxSeason = season;
        this.newSeasonColor = this.seasonColor = season.getSeasonColor();
        this.method_1880(8);
        this.method_1852(String.valueOf(this.seasonColor));
        this.method_1863(colorString -> {
            if (this.validate((String)colorString)) {
                this.method_1868(0xFFFFFF);
                int colorInt = Integer.parseInt(colorString);
                if (colorInt != this.newSeasonColor) {
                    this.newSeasonColor = colorInt;
                    this.method_1852((String)colorString);
                }
                ColorScreen.doneButton.field_22763 = true;
            } else {
                this.method_1868(0xFF5555);
                ColorScreen.doneButton.field_22763 = false;
            }
        });
    }

    private static EnumSet<SeasonList> seasonListSet() {
        Object set = SeasonList.seasons.clone();
        if (!((Boolean)Config.showTropicalSeason.get()).booleanValue() || !Services.PLATFORM.getPlatformName().equals("Forge")) {
            ((AbstractCollection)set).remove((Object)SeasonList.DRY);
            ((AbstractCollection)set).remove((Object)SeasonList.WET);
        }
        return set;
    }

    private boolean inBounds(int color) {
        int minColor = 0;
        int maxColor = 0xFFFFFF;
        return color >= minColor && color <= maxColor;
    }

    public boolean validate(String colorString) {
        try {
            int colorInt = Integer.parseInt(colorString);
            return this.inBounds(colorInt);
        }
        catch (NumberFormatException var) {
            return false;
        }
    }

    public void save() {
        Rgb.setRgb(this.boxSeason, this.newSeasonColor);
        this.boxSeason.setColor(this.newSeasonColor);
    }

    public int getColor() {
        return this.seasonColor;
    }

    public int getNewColor() {
        return this.newSeasonColor;
    }

    public SeasonList getSeason() {
        return this.boxSeason;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        String seasonIcon = this.boxSeason.getIconChar();
        String seasonFileName = this.boxSeason.getFileName();
        boolean enableSeasonNameColor = (Boolean)Config.enableSeasonNameColor.get();
        this.method_1888(enableSeasonNameColor);
        class_2583 SEASON_FORMAT = class_2583.field_24360;
        if (enableSeasonNameColor) {
            SEASON_FORMAT = class_2583.field_24360.method_36139(this.newSeasonColor);
        }
        class_5250 icon = class_2561.method_43469((String)"desc.seasonhud.icon", (Object[])new Object[]{seasonIcon}).method_27696(Common.SEASON_STYLE);
        class_5250 season = class_2561.method_43469((String)"desc.seasonhud.summary", (Object[])new Object[]{class_2561.method_43471((String)("desc.seasonhud." + seasonFileName))}).method_27696(SEASON_FORMAT);
        int widgetTotalSize = 86 * ColorEditBox.seasonListSet().size();
        int scaledWidth = SeasonHUDClient.mc.method_22683().method_4486();
        if (this.boxSeason == SeasonList.DRY && scaledWidth < widgetTotalSize) {
            season = class_2561.method_43471((String)"menu.seasonhud.color.editbox.dryColor").method_27696(SEASON_FORMAT);
        }
        if (this.boxSeason == SeasonList.WET && scaledWidth < widgetTotalSize) {
            season = class_2561.method_43471((String)"menu.seasonhud.color.editbox.wetColor").method_27696(SEASON_FORMAT);
        }
        class_5250 seasonCombined = class_2561.method_43469((String)"desc.seasonhud.combined", (Object[])new Object[]{icon, season});
        graphics.method_51448().method_22903();
        float scale = 1.0f;
        if (SeasonHUDClient.mc.field_1772.method_27525((class_5348)seasonCombined) > this.method_25368() - 4) {
            scale = ((float)this.method_25368() - 4.0f) / (float)SeasonHUDClient.mc.field_1772.method_27525((class_5348)seasonCombined);
        }
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        class_327 class_3272 = SeasonHUDClient.mc.field_1772;
        int n = (int)(((double)this.method_46426() + (double)this.method_25368() / 2.0) / (double)scale);
        float f = this.method_46427();
        Objects.requireNonNull(SeasonHUDClient.mc.field_1772);
        graphics.method_27534(class_3272, (class_2561)seasonCombined, n, (int)((f - 9.0f * scale - 4.0f) / scale), 0xFFFFFF);
        graphics.method_51448().method_22909();
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }
}

