/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.mgin.graves.command.utility.ArgumentUtility;
import me.mgin.graves.command.utility.Interact;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.state.PlayerState;
import me.mgin.graves.state.ServerState;
import me.mgin.graves.util.DateFormatter;
import me.mgin.graves.util.NbtHelper;
import me.mgin.graves.util.Responder;
import me.mgin.graves.versioned.VersionedCode;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class ListCommand {
    public static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer;
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        Responder res = new Responder((class_1657)source.method_44023(), server);
        int page = ArgumentUtility.getIntegerArgument(context, "page", 3);
        GameProfile player = ArgumentUtility.getProfileArgument(context, "player", 4);
        GameProfile recipient = ArgumentUtility.getProfileArgument(context, "recipient", 5);
        if (player == null && source.method_44023() == null) {
            res.send((class_2561)class_2561.method_43471((String)"command.generic.error.specify-player"), null);
            return 1;
        }
        if (source.method_44023() != null && player != null && !(sourcePlayer = source.method_44023()).method_5687(4) && !sourcePlayer.method_5667().equals(player.getId())) {
            res.sendError((class_2561)class_2561.method_43471((String)"command.generic.error.no-permission"), null);
            return 1;
        }
        GameProfile target = player != null ? player : Objects.requireNonNull(source.method_44023()).method_7334();
        ListCommand.executeWithoutCommand(res, target, recipient, page, server, source.method_44023());
        return 1;
    }

    public static void executeWithoutCommand(Responder res, GameProfile target, GameProfile recipient, int page, MinecraftServer server, class_3222 issuer) {
        GravesConfig config = GravesConfig.getConfig();
        if (page == -1) {
            page = 1;
        }
        PlayerState playerState = ServerState.getPlayerState(server, target.getId());
        int endOfPage = page * 5;
        int startOfPage = endOfPage - 5;
        HashMap<Integer, class_2487> graves = new HashMap<Integer, class_2487>();
        for (int i = 0; i < playerState.graves.size(); ++i) {
            class_2487 grave = playerState.graves.method_10602(i);
            if (issuer != null && !issuer.method_5687(4) && grave.method_10577("retrieved")) continue;
            graves.put(i, grave);
        }
        if (startOfPage >= config.server.storedGravesAmount || startOfPage >= graves.size()) {
            res.sendInfo((class_2561)(page == 1 ? class_2561.method_43469((String)"command.list.error.no-graves", (Object[])new Object[]{res.highlight(target.getName())}) : class_2561.method_43469((String)"command.list.error.no-graves-on-page", (Object[])new Object[]{page, res.highlight(target.getName())})), null);
            return;
        }
        ListCommand.sendGraveList(res, target, issuer, recipient, page, startOfPage, endOfPage, graves);
    }

    private static void sendGraveList(Responder res, GameProfile target, class_3222 issuer, GameProfile recipient, int page, int startOfPage, int endOfPage, Map<Integer, class_2487> graves) {
        int amountOfPages = (int)Math.ceil((double)graves.size() / 5.0);
        if (issuer != null) {
            res.send((class_2561)class_2561.method_43470((String)""), null);
        }
        res.sendInfo((class_2561)class_2561.method_43469((String)"command.list.header", (Object[])new Object[]{res.highlight(target.getName())}), null);
        if (issuer != null) {
            res.send((class_2561)class_2561.method_43470((String)" "), null);
        }
        int index = 0;
        for (Map.Entry<Integer, class_2487> entry : graves.entrySet()) {
            if (++index - 1 == endOfPage) break;
            if (startOfPage > index - 1) continue;
            int i = entry.getKey();
            class_2487 grave = entry.getValue();
            class_5250 itemMessage = class_2561.method_43470((String)"").method_10852(ListCommand.genListCommandEntry(res, grave, issuer, recipient, target.getName(), i));
            res.sendInfo((class_2561)itemMessage, null);
        }
        if (issuer != null) {
            res.send((class_2561)class_2561.method_43470((String)" "), null);
        }
        String recipientName = recipient != null ? recipient.getName() : target.getName();
        String paginationCommand = issuer != null && issuer.method_5687(4) ? "/graves list %d " + String.format("%s %s", target.getName(), recipientName) : "/graves list %d";
        res.sendInfo(Interact.generatePagination(res, page, amountOfPages, paginationCommand), null);
        if (issuer != null) {
            res.send((class_2561)class_2561.method_43470((String)""), null);
        }
    }

    private static class_2561 genListCommandEntry(Responder res, class_2487 grave, class_3222 issuer, GameProfile recipient, String target, int i) {
        String created = DateFormatter.formatDate(grave.method_10537("mstime"));
        String dimension = grave.method_10558("dimension");
        boolean retrieved = grave.method_10577("retrieved");
        class_2338 pos = NbtHelper.readCoordinates(grave);
        class_2561 xText = retrieved ? res.dim(pos.method_10263()) : res.dimension(pos.method_10263(), dimension);
        class_2561 yText = retrieved ? res.dim(pos.method_10264()) : res.dimension(pos.method_10264(), dimension);
        class_2561 zText = retrieved ? res.dim(pos.method_10260()) : res.dimension(pos.method_10260(), dimension);
        class_2561 hoverContent = res.info(class_2561.method_43469((String)"command.list.entry.tooltip", (Object[])new Object[]{res.highlight(dimension), res.highlight(i + 1), res.highlight(created), res.highlight(retrieved ? "Yes" : "No")}));
        class_5250 message = issuer == null ? class_2561.method_43470((String)"").method_10852(res.info(String.format("%d. ", i))).method_10852((class_2561)class_2561.method_43469((String)"grave.coordinates", (Object[])new Object[]{xText, yText, zText})).method_10852((class_2561)(retrieved ? class_2561.method_43470((String)" (\u2713)") : class_2561.method_43470((String)""))) : class_2561.method_43469((String)"grave.coordinates", (Object[])new Object[]{xText, yText, zText});
        if (issuer != null && issuer.method_5687(4)) {
            if (!retrieved) {
                hoverContent = hoverContent.method_27661().method_10852(res.hint(class_2561.method_43471((String)"command.list.entry.tooltip.click-to-teleport")));
                message = res.runOnClick((class_2561)message, String.format("/execute as %s in %s run tp %d %d %d", VersionedCode.getIssuerName(issuer), dimension, pos.method_10263(), pos.method_10264(), pos.method_10260()));
            }
            String rec = recipient != null ? recipient.getName() : target;
            message = message.method_27661().method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(Interact.generateButton(res, res.success(class_2561.method_43471((String)"command.list.entry.restore-button")), res.hint(class_2561.method_43469((String)"command.list.entry.restore-button.tooltip", (Object[])new Object[]{i + 1, rec})), String.format("/graves restore %s %d %s true", target, i + 1, rec)));
            message = message.method_27661().method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(Interact.generateButton(res, res.error(class_2561.method_43471((String)"command.list.entry.delete-button")), res.hint(class_2561.method_43469((String)"command.list.entry.delete-button.tooltip", (Object[])new Object[]{i + 1})), String.format("/graves delete %s %d true %s", target, i + 1, rec)));
        }
        return res.hoverText((class_2561)message, hoverContent);
    }
}

