/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.utility;

import com.mojang.authlib.GameProfile;
import java.util.Date;
import me.mgin.graves.Graves;
import me.mgin.graves.api.InventoriesApi;
import me.mgin.graves.block.GraveBlocks;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.block.utility.Dimension;
import me.mgin.graves.block.utility.Experience;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.state.ServerState;
import me.mgin.graves.tags.BlockTags;
import me.mgin.graves.util.Responder;
import me.mgin.graves.versioned.VersionedCode;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public class PlaceGrave {
    public static void place(class_1937 world, class_243 vecPos, class_1657 player) {
        if (world.method_8608()) {
            return;
        }
        Dimension dimension = new Dimension(world);
        class_2338 pos = dimension.enforceBoundaries(new class_2338((int)Math.floor(vecPos.field_1352), (int)Math.floor(vecPos.field_1351), (int)Math.floor(vecPos.field_1350)));
        if (PlaceGrave.graveShouldSink(world, pos, player)) {
            pos = PlaceGrave.findLowestSpawnPos(world, dimension, pos, player);
        }
        if (!PlaceGrave.canPlaceGrave(world, dimension, pos) || !PlaceGrave.isLiquidAirOrReplaceable(world, pos)) {
            pos = PlaceGrave.findOptimalSpawnPos(world, dimension, pos, player);
        }
        PlaceGrave.spawnGrave(world, pos, player);
    }

    private static class_2338 findLowestSpawnPos(class_1937 world, Dimension dimension, class_2338 pos, class_1657 player) {
        int depth = dimension.getMinY() + 1;
        int start = pos.method_10264() - 1;
        class_2338 finalPos = pos;
        for (int i = start; i >= depth; --i) {
            class_2338 newPos = new class_2338(pos.method_10263(), i, pos.method_10260());
            if (!PlaceGrave.graveShouldSink(world, newPos, player)) {
                finalPos = newPos;
                break;
            }
            if (i != depth) continue;
            finalPos = newPos;
        }
        return finalPos;
    }

    private static class_2338 findOptimalSpawnPos(class_1937 world, Dimension dimension, class_2338 pos, class_1657 player) {
        class_2338 suboptimalPos = pos;
        for (class_2338 newPos : class_2338.method_25996((class_2338)pos, (int)8, (int)80, (int)8)) {
            if (!PlaceGrave.canPlaceGrave(world, dimension, newPos)) continue;
            if (PlaceGrave.graveShouldSink(world, newPos, player)) {
                newPos = PlaceGrave.findLowestSpawnPos(world, dimension, newPos, player);
            }
            if (PlaceGrave.isLiquidAirOrReplaceable(world, newPos)) {
                return newPos;
            }
            boolean suboptimalUnchanged = suboptimalPos == pos;
            boolean cantPlaceInitial = !PlaceGrave.canPlaceGrave(world, dimension, pos);
            boolean canPlaceNewPos = PlaceGrave.canPlaceGrave(world, dimension, newPos);
            if (!suboptimalUnchanged || !cantPlaceInitial || !canPlaceNewPos) continue;
            suboptimalPos = newPos;
        }
        return suboptimalPos;
    }

    public static void spawnGrave(class_1937 world, class_2338 pos, class_1657 player) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        world.method_8501(pos, (class_2680)GraveBlocks.GRAVE.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)player.method_5735().method_10153()));
        GraveBlockEntity graveEntity = new GraveBlockEntity(pos, world.method_8320(pos));
        for (InventoriesApi api : Graves.inventories) {
            class_2371<class_1799> inventory = api.getInventory(player);
            if (inventory == null) continue;
            graveEntity.setInventory(api.getID(), inventory);
            api.clearInventory(player);
        }
        graveEntity.setGraveOwner(player.method_7334());
        int experience = Experience.calculatePlayerExperience(player);
        graveEntity.setXp(experience);
        PlaceGrave.resetPlayerExperience(player);
        graveEntity.setMstime(new Date().getTime());
        block.method_9576(world, pos, state, player);
        world.method_8438((class_2586)graveEntity);
        ServerState.storePlayerGrave(player, graveEntity);
        boolean graveCoordinates = (Boolean)GravesConfig.resolve("graveCoordinates", player.method_7334());
        if (graveCoordinates) {
            Responder res = new Responder(player, player.method_5682());
            String dimension = String.valueOf(world.method_44013().method_29177());
            res.sendInfo((class_2561)class_2561.method_43469((String)"event.death:send-player-coordinates", (Object[])new Object[]{res.dimension(pos.method_10263(), dimension), res.dimension(pos.method_10264(), dimension), res.dimension(pos.method_10260(), dimension)}), null);
        }
        System.out.printf("[%s] Grave spawned at: %dx %dy %dz for player %s.\n", Graves.MOD_ID, pos.method_10263(), pos.method_10264(), pos.method_10260(), player.method_5477().getString());
    }

    private static void resetPlayerExperience(class_1657 player) {
        player.field_7495 = 0;
        player.field_7510 = 0.0f;
        player.field_7520 = 0;
    }

    private static boolean canPlaceGrave(class_1937 world, Dimension dimension, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        if (VersionedCode.TagContains(state, BlockTags.DO_NOT_REPLACE)) {
            return false;
        }
        return dimension.inBounds(pos);
    }

    public static boolean graveShouldSink(class_1937 world, class_2338 pos, class_1657 player) {
        pos = pos.method_10074();
        GameProfile profile = player.method_7334();
        class_2248 block = world.method_8320(pos).method_26204();
        if (!PlaceGrave.isLiquidAirOrReplaceable(world, pos)) {
            return false;
        }
        return switch (block.method_9518().getString()) {
            case "Air" -> (Boolean)GravesConfig.resolve("sinkInAir", profile);
            case "Water" -> (Boolean)GravesConfig.resolve("sinkInWater", profile);
            case "Lava" -> (Boolean)GravesConfig.resolve("sinkInLava", profile);
            default -> false;
        };
    }

    private static boolean isLiquidAirOrReplaceable(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        boolean canReplace = VersionedCode.TagContains(state, BlockTags.REPLACE);
        return state.method_26215() || state.method_51176() || canReplace;
    }
}

