/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.utility;

import me.mgin.graves.block.GraveBlockBase;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.config.enums.GraveRetrievalType;
import net.minecraft.class_1657;

public class Permission {
    public static boolean playerCanAttemptRetrieve(class_1657 player, GraveBlockEntity graveEntity) {
        if (graveEntity.getGraveOwner() == null) {
            return true;
        }
        GravesConfig config = GravesConfig.getConfig();
        int decayRobbing = GravesConfig.getConfig().decay.decayRobbing.ordinal();
        int graveStageOrdinal = ((GraveBlockBase)graveEntity.getState().method_26204()).getDecayStage().ordinal();
        boolean isGraveOwner = graveEntity.isGraveOwner(player);
        boolean canDecayRob = graveStageOrdinal >= decayRobbing;
        boolean graveRobbing = config.server.graveRobbing;
        boolean canOverride = Permission.playerCanOverride(player);
        return isGraveOwner || canDecayRob && graveRobbing || canOverride;
    }

    public static boolean playerCanOverride(class_1657 player) {
        int OPOverrideLevel = GravesConfig.getConfig().server.OPOverrideLevel;
        return OPOverrideLevel != -1 && player.method_5687(OPOverrideLevel);
    }

    public static boolean playerCanBreakGrave(class_1657 player, GraveBlockEntity graveEntity) {
        GraveRetrievalType retrievalType = (GraveRetrievalType)((Object)GravesConfig.resolve("retrievalType", player.method_7334()));
        if (Permission.playerCanAttemptRetrieve(player, graveEntity)) {
            return retrievalType == GraveRetrievalType.BREAK || retrievalType == GraveRetrievalType.BOTH;
        }
        return false;
    }

    public static boolean playerCanUseGrave(class_1657 player, GraveBlockEntity graveEntity) {
        GraveRetrievalType retrievalType = (GraveRetrievalType)((Object)GravesConfig.resolve("retrievalType", player.method_7334()));
        if (Permission.playerCanAttemptRetrieve(player, graveEntity)) {
            return retrievalType == GraveRetrievalType.USE || retrievalType == GraveRetrievalType.BOTH;
        }
        return false;
    }
}

