/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import me.mgin.graves.Graves;
import me.mgin.graves.api.InventoriesApi;
import me.mgin.graves.block.GraveBlocks;
import me.mgin.graves.util.NbtHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class GraveBlockEntity
extends class_2586 {
    private GameProfile graveOwner = null;
    private class_2680 state;
    private int xp = 0;
    private int noDecay = 0;
    private String customName = "";
    private class_2487 graveSkull = null;
    private long mstime = 0L;
    private final Map<String, class_2371<class_1799>> inventories = new HashMap<String, class_2371<class_1799>>(){};

    public GraveBlockEntity(class_2338 pos, class_2680 state) {
        super(GraveBlocks.GRAVE_BLOCK_ENTITY, pos, state);
        this.setState(state);
    }

    public void setInventory(String key, class_2371<class_1799> items) {
        this.inventories.put(key, items);
        this.method_5431();
    }

    public class_2371<class_1799> getInventory(String key) {
        return this.inventories.get(key);
    }

    public void setGraveOwner(GameProfile profile) {
        this.graveOwner = profile;
        this.method_5431();
    }

    public GameProfile getGraveOwner() {
        return this.graveOwner;
    }

    public boolean isGraveOwner(class_1657 player) {
        return this.graveOwner.getId().equals(player.method_7334().getId());
    }

    public void setCustomName(String name) {
        this.customName = name;
        this.method_5431();
    }

    public String getCustomName() {
        return this.customName;
    }

    public boolean hasCustomName() {
        return this.customName.length() > 0;
    }

    public void setState(class_2680 state) {
        this.state = state;
    }

    public class_2680 getState() {
        return this.state;
    }

    public void setXp(int xp) {
        this.xp = xp;
        this.method_5431();
    }

    public int getXp() {
        return this.xp;
    }

    public void setMstime(long timeInMilliseconds) {
        this.mstime = timeInMilliseconds;
        this.method_5431();
    }

    public long getMstime() {
        return this.mstime;
    }

    public void setNoDecay(int aging) {
        this.noDecay = aging;
        this.method_5431();
    }

    public int getNoDecay() {
        return this.noDecay;
    }

    public void setGraveSkull(class_2487 graveSkull) {
        this.graveSkull = graveSkull;
        this.method_5431();
    }

    public class_2487 getGraveSkull() {
        return this.graveSkull;
    }

    public boolean hasGraveSkull() {
        if (this.graveSkull == null) {
            return false;
        }
        return !this.graveSkull.method_33133();
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        for (InventoriesApi api : Graves.inventories) {
            String id = api.getID();
            class_2371<class_1799> inventory = this.getInventory(id);
            if (inventory == null) continue;
            nbt = NbtHelper.writeInventory(id, inventory, nbt);
        }
        for (String modID : Graves.unloadedInventories) {
            class_2371<class_1799> inventory = this.getInventory(modID);
            if (inventory == null) continue;
            nbt = NbtHelper.writeInventory(modID, inventory, nbt);
        }
        nbt.method_10569("XP", this.xp);
        nbt.method_10569("noDecay", this.noDecay);
        nbt.method_10544("mstime", this.mstime);
        if (this.graveOwner != null) {
            nbt.method_10566("GraveOwner", (class_2520)NbtHelper.writeGameProfile(new class_2487(), this.graveOwner));
        }
        if (this.customName != null && this.hasCustomName()) {
            nbt.method_10582("CustomName", this.customName);
        }
        if (this.graveSkull != null) {
            nbt.method_10566("GraveSkull", (class_2520)this.graveSkull);
        }
    }

    public void method_11014(class_2487 nbt) {
        nbt = NbtHelper.upgradeOldGraves(nbt);
        super.method_11014(nbt);
        for (InventoriesApi api : Graves.inventories) {
            String id = api.getID();
            if (!nbt.method_10545(id)) continue;
            this.setInventory(id, NbtHelper.readInventory(id, nbt));
        }
        for (String modID : Graves.unloadedInventories) {
            if (!nbt.method_10545(modID)) continue;
            this.setInventory(modID, NbtHelper.readInventory(modID, nbt));
        }
        this.xp = nbt.method_10550("XP");
        this.noDecay = nbt.method_10550("noDecay");
        this.mstime = nbt.method_10537("mstime");
        if (nbt.method_10545("GraveOwner")) {
            this.graveOwner = NbtHelper.toGameProfile(nbt.method_10562("GraveOwner"));
        }
        if (nbt.method_10545("CustomName")) {
            this.customName = nbt.method_10558("CustomName");
        }
        if (nbt.method_10545("GraveSkull")) {
            this.graveSkull = (class_2487)nbt.method_10580("GraveSkull");
        }
        super.method_5431();
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_39026((class_2586)this, b -> this.toNbt());
    }

    public class_2487 method_16887() {
        return this.toNbt();
    }
}

