/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.decay;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import me.mgin.graves.block.GraveBlocks;
import me.mgin.graves.block.decay.Decayable;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public interface DecayingGrave
extends Decayable<BlockDecay> {
    public static final Supplier<ImmutableBiMap<Object, Object>> BLOCK_DECAY_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)GraveBlocks.GRAVE, (Object)GraveBlocks.GRAVE_OLD).put((Object)GraveBlocks.GRAVE_OLD, (Object)GraveBlocks.GRAVE_WEATHERED).put((Object)GraveBlocks.GRAVE_WEATHERED, (Object)GraveBlocks.GRAVE_FORGOTTEN).build());
    public static final Supplier<BiMap<Object, Object>> BLOCK_DECAY_DECREASES = Suppliers.memoize(() -> ((BiMap)BLOCK_DECAY_INCREASES.get()).inverse());

    public static Optional<class_2248> getDecreasedDecayBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)BLOCK_DECAY_DECREASES.get().get((Object)block));
    }

    public static Optional<class_2680> getDecreasedDecayState(class_2680 state) {
        return DecayingGrave.getDecreasedDecayBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    public static Optional<class_2248> getIncreasedDecayBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)((BiMap)BLOCK_DECAY_INCREASES.get()).get((Object)block));
    }

    public static Optional<class_2680> getIncreasedDecayState(class_2680 state) {
        return DecayingGrave.getIncreasedDecayBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    @Override
    default public Optional<class_2680> getDecayResultState(class_2680 state) {
        return DecayingGrave.getIncreasedDecayBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    @Override
    default public float getDecayChanceMultiplier() {
        return this.getDecayStage() == BlockDecay.FRESH ? 0.75f : 1.0f;
    }

    public static enum BlockDecay {
        FRESH,
        OLD,
        WEATHERED,
        FORGOTTEN;

    }
}

