/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.decay;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import me.mgin.graves.Graves;
import me.mgin.graves.api.InventoriesApi;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.config.GravesConfig;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public interface Decayable<T extends Enum<T>> {
    public Optional<class_2680> getDecayResultState(class_2680 var1);

    public float getDecayChanceMultiplier();

    default public void tickDecay(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        GravesConfig config = GravesConfig.getConfig();
        if (config.decay.decayEnabled) {
            float f = 0.05688889f;
            if (random.method_43057() < f) {
                this.tryDecay(state, world, pos, random);
            }
        }
    }

    public T getDecayStage();

    default public void tryDecay(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.getDecayChanceMultiplier() > random.method_43057()) {
            this.getDecayResultState(state).ifPresent(statex -> Decayable.setDecayState((class_1937)world, pos, statex, true));
        }
    }

    public static class_2371<class_1799> decayItems(class_2371<class_1799> items, GameProfile profile) {
        GravesConfig config = GravesConfig.getConfig();
        float modifier = (float)config.decay.decayModifier / 100.0f;
        boolean decayBreaksItems = config.decay.decayBreaksItems;
        if (modifier == 0.0f) {
            return items;
        }
        for (int i = 0; i < items.size(); ++i) {
            class_1799 item = (class_1799)items.get(i);
            int maxDamage = item.method_7936();
            int damage = item.method_7919();
            if (maxDamage <= 0) continue;
            class_5819 random = class_5819.method_43047();
            float unbreaking = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)item);
            float currentItemDecay = (float)damage / (float)maxDamage;
            if (currentItemDecay == 0.0f) {
                currentItemDecay = 1.0f / (float)maxDamage;
            }
            float decayPercent = modifier * currentItemDecay;
            float unbreakingModifier = 100.0f / (unbreaking + 1.0f) / 100.0f;
            float decayChance = 0.35f * unbreakingModifier;
            if (!(decayChance >= random.method_43057())) continue;
            int remainingDamage = maxDamage - damage;
            int decay = (int)Math.ceil((float)remainingDamage * decayPercent);
            if (remainingDamage - decay > 0) {
                item.method_7974(damage + decay);
                continue;
            }
            if (decayBreaksItems) {
                items.set(i, (Object)class_1799.field_8037);
                continue;
            }
            item.method_7974(maxDamage - 1);
        }
        return items;
    }

    public static void setDecayState(class_1937 world, class_2338 pos, class_2680 state, boolean itemsDecay) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GraveBlockEntity) {
            GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
            world.method_8501(pos, state);
            GraveBlockEntity newGraveEntity = new GraveBlockEntity(pos, state);
            GameProfile owner = graveEntity.getGraveOwner();
            newGraveEntity.method_11014(graveEntity.toNbt());
            for (InventoriesApi api : Graves.inventories) {
                String id = api.getID();
                class_2371<class_1799> inventory = graveEntity.getInventory(id);
                if (inventory == null) continue;
                newGraveEntity.setInventory(id, itemsDecay ? Decayable.decayItems(inventory, owner) : inventory);
            }
            world.method_8438((class_2586)newGraveEntity);
        }
    }
}

