/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import satisfy.bloomingnature.BloomingNature;
import satisfy.bloomingnature.entity.BisonEntity;
import satisfy.bloomingnature.entity.BoarEntity;
import satisfy.bloomingnature.entity.DeerEntity;
import satisfy.bloomingnature.entity.MossySheepEntity;
import satisfy.bloomingnature.entity.MuddyPigEntity;
import satisfy.bloomingnature.entity.OwlEntity;
import satisfy.bloomingnature.entity.PelicanEntity;
import satisfy.bloomingnature.entity.RaccoonEntity;
import satisfy.bloomingnature.entity.RedWolfEntity;
import satisfy.bloomingnature.entity.SheepEntity;
import satisfy.bloomingnature.entity.SquirrelEntity;
import satisfy.bloomingnature.entity.TermiteEntity;
import satisfy.bloomingnature.entity.TurkeyEntity;
import satisfy.bloomingnature.entity.WanderingGardenerEntity;
import satisfy.bloomingnature.util.BloomingNatureIdentifier;

public class EntityRegistry {
    private static final DeferredRegister<class_1299<?>> ENTITY_TYPES = DeferredRegister.create((String)"bloomingnature", (class_5321)class_7924.field_41266);
    public static final RegistrySupplier<class_1299<WanderingGardenerEntity>> WANDERING_GARDENER = EntityRegistry.create("wandering_gardener", () -> class_1299.class_1300.method_5903(WanderingGardenerEntity::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 1.95f).method_27299(10).method_5905(new BloomingNatureIdentifier("wandering_gardener").toString()));
    public static final RegistrySupplier<class_1299<RedWolfEntity>> RED_WOLF = EntityRegistry.create("red_wolf", () -> class_1299.class_1300.method_5903(RedWolfEntity::new, (class_1311)class_1311.field_6294).method_17687(0.4f, 1.5f).method_27299(10).method_5905(new BloomingNatureIdentifier("red_wolf").toString()));
    public static final RegistrySupplier<class_1299<PelicanEntity>> PELICAN = EntityRegistry.create("pelican", () -> class_1299.class_1300.method_5903(PelicanEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.3f).method_5905(new BloomingNatureIdentifier("pelican").toString()));
    public static final RegistrySupplier<class_1299<RaccoonEntity>> RACCOON = EntityRegistry.create("raccoon", () -> class_1299.class_1300.method_5903(RaccoonEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.3f).method_5905(new BloomingNatureIdentifier("raccoon").toString()));
    public static final RegistrySupplier<class_1299<MossySheepEntity>> MOSSY_SHEEP = EntityRegistry.create("mossy_sheep", () -> class_1299.class_1300.method_5903(MossySheepEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.3f).method_5905(new class_2960("bloomingnature", "mossy_sheep").toString()));
    public static final RegistrySupplier<class_1299<SquirrelEntity>> SQUIRREL = EntityRegistry.create("squirrel", () -> class_1299.class_1300.method_5903(SquirrelEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.3f).method_5905(new BloomingNatureIdentifier("raccoon").toString()));
    public static final RegistrySupplier<class_1299<MuddyPigEntity>> MUDDY_PIG = EntityRegistry.create("muddy_pig", () -> class_1299.class_1300.method_5903(MuddyPigEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.3f).method_5905(new BloomingNatureIdentifier("muddy_pig").toString()));
    public static final RegistrySupplier<class_1299<TurkeyEntity>> TURKEY = EntityRegistry.create("turkey", () -> class_1299.class_1300.method_5903(TurkeyEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.3f).method_5905(new BloomingNatureIdentifier("turkey").toString()));
    public static final RegistrySupplier<class_1299<DeerEntity>> DEER = EntityRegistry.create("deer", () -> class_1299.class_1300.method_5903(DeerEntity::new, (class_1311)class_1311.field_6294).method_5905(new BloomingNatureIdentifier("deer").toString()));
    public static final RegistrySupplier<class_1299<OwlEntity>> OWL = EntityRegistry.create("owl", () -> class_1299.class_1300.method_5903(OwlEntity::new, (class_1311)class_1311.field_6294).method_5905(new BloomingNatureIdentifier("owl").toString()));
    public static final RegistrySupplier<class_1299<TermiteEntity>> TERMITE = EntityRegistry.create("termite", () -> class_1299.class_1300.method_5903(TermiteEntity::new, (class_1311)class_1311.field_6302).method_5905(new BloomingNatureIdentifier("termite").toString()));
    public static final RegistrySupplier<class_1299<BoarEntity>> BOAR = EntityRegistry.create("boar", () -> class_1299.class_1300.method_5903(BoarEntity::new, (class_1311)class_1311.field_6294).method_5905(new BloomingNatureIdentifier("boar").toString()));
    public static final RegistrySupplier<class_1299<BisonEntity>> BISON = EntityRegistry.create("bison", () -> class_1299.class_1300.method_5903(BisonEntity::new, (class_1311)class_1311.field_6294).method_5905(new BloomingNatureIdentifier("bison").toString()));

    public static <T extends class_1299<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((class_2960)new BloomingNatureIdentifier(path), type);
    }

    public static void init() {
        BloomingNature.LOGGER.debug("Registering Entities for bloomingnature");
        ENTITY_TYPES.register();
        EntityAttributeRegistry.register(WANDERING_GARDENER, class_1308::method_26828);
        EntityAttributeRegistry.register(MOSSY_SHEEP, SheepEntity::createMobAttributes);
        EntityAttributeRegistry.register(DEER, DeerEntity::createMobAttributes);
        EntityAttributeRegistry.register(PELICAN, PelicanEntity::createMobAttributes);
        EntityAttributeRegistry.register(RED_WOLF, RedWolfEntity::createMobAttributes);
        EntityAttributeRegistry.register(RACCOON, RaccoonEntity::createMobAttributes);
        EntityAttributeRegistry.register(SQUIRREL, SquirrelEntity::createMobAttributes);
        EntityAttributeRegistry.register(MUDDY_PIG, MuddyPigEntity::createMobAttributes);
        EntityAttributeRegistry.register(OWL, OwlEntity::createMobAttributes);
        EntityAttributeRegistry.register(BOAR, BoarEntity::createMobAttributes);
        EntityAttributeRegistry.register(TERMITE, TermiteEntity::createMobAttributes);
        EntityAttributeRegistry.register(BISON, BisonEntity::createMobAttributes);
        EntityAttributeRegistry.register(TURKEY, TurkeyEntity::createMobAttributes);
    }
}

