/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.fabric;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import satisfy.bloomingnature.BloomingNature;
import satisfy.bloomingnature.registry.CompostableRegistry;
import satisfy.bloomingnature.registry.EntityRegistry;
import satisfy.bloomingnature.registry.TagsRegistry;
import satisfy.bloomingnature.util.BloomingNatureIdentifier;
import satisfy.bloomingnature.world.PlacedFeatures;

public class BloomingNatureFabric
implements ModInitializer {
    public void onInitialize() {
        BloomingNature.init();
        BloomingNature.commonInit();
        CompostableRegistry.init();
        this.addSpawns();
        this.addBiomeModification();
    }

    void addSpawns() {
        this.addMobSpawn(TagsRegistry.SPAWNS_DEER, class_1311.field_6294, (class_1299)EntityRegistry.DEER.get(), 12, 2, 4);
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_36510, class_1311.field_6294, (class_1299)EntityRegistry.PELICAN.get(), 5, 3, 4);
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_36501, class_1311.field_6294, class_1299.field_6090, 4, 1, 2);
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_36501, class_1311.field_6294, class_1299.field_6117, 4, 1, 2);
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_36501, class_1311.field_6294, class_1299.field_6105, 4, 1, 3);
        this.addMobSpawn(TagsRegistry.SPAWNS_MUDDY_PIG, class_1311.field_6294, (class_1299)EntityRegistry.MUDDY_PIG.get(), 8, 4, 5);
        this.addMobSpawn(TagsRegistry.SPAWNS_MOSSY_SHEEP, class_1311.field_6294, (class_1299)EntityRegistry.MOSSY_SHEEP.get(), 8, 3, 5);
        this.addMobSpawn(TagsRegistry.SPAWNS_RACCOON, class_1311.field_6294, (class_1299)EntityRegistry.RACCOON.get(), 8, 2, 3);
        this.addMobSpawn(TagsRegistry.SPAWNS_SQUIRREL, class_1311.field_6294, (class_1299)EntityRegistry.SQUIRREL.get(), 8, 2, 2);
        this.addMobSpawn(TagsRegistry.SPAWNS_RED_WOLF, class_1311.field_6294, (class_1299)EntityRegistry.RED_WOLF.get(), 10, 3, 4);
        this.addMobSpawn(TagsRegistry.SPAWNS_OWL, class_1311.field_6294, (class_1299)EntityRegistry.OWL.get(), 12, 3, 3);
        this.addMobSpawn(TagsRegistry.SPAWNS_BOAR, class_1311.field_6294, (class_1299)EntityRegistry.BOAR.get(), 14, 5, 5);
        this.addMobSpawn(TagsRegistry.SPAWNS_BISON, class_1311.field_6294, (class_1299)EntityRegistry.BISON.get(), 10, 3, 5);
        this.addMobSpawn(TagsRegistry.SPAWNS_TURKEY, class_1311.field_6294, (class_1299)EntityRegistry.TURKEY.get(), 12, 3, 5);
        this.addMobSpawn(TagsRegistry.SPAWNS_TURKEY, class_1311.field_6294, (class_1299)EntityRegistry.TURKEY.get(), 12, 3, 5);
        this.removeSpawn((class_6862<class_1959>)class_6908.field_37392, List.of(class_1299.field_6115, class_1299.field_6093, class_1299.field_6132, class_1299.field_6085));
        this.removeSpawn((class_6862<class_1959>)ConventionalBiomeTags.SWAMP, List.of(class_1299.field_6115, class_1299.field_6093, class_1299.field_6132, class_1299.field_6085));
        this.removeSpawn((class_6862<class_1959>)class_6908.field_36517, List.of(class_1299.field_6093, class_1299.field_6132));
        this.removeSpawn((class_6862<class_1959>)class_6908.field_36516, List.of(class_1299.field_6093, class_1299.field_6132, class_1299.field_6085));
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_36516, class_1311.field_6294, class_1299.field_37419, 8, 3, 4);
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_37392, class_1311.field_6294, (class_1299)EntityRegistry.TERMITE.get(), 10, 3, 4);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.SQUIRREL.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.TERMITE.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.OWL.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13197, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.TURKEY.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.RACCOON.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.PELICAN.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.MUDDY_PIG.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.DEER.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.MOSSY_SHEEP.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.RED_WOLF.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.BOAR.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.BISON.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
    }

    void addMobSpawn(class_6862<class_1959> tag, class_1311 mobCategory, class_1299<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        BiomeModifications.addSpawn(biomeSelector -> biomeSelector.hasTag(tag), (class_1311)mobCategory, entityType, (int)weight, (int)minGroupSize, (int)maxGroupSize);
    }

    void removeSpawn(class_6862<class_1959> tag, List<class_1299<?>> entityTypes) {
        entityTypes.forEach(entityType -> {
            class_2960 id = class_7923.field_41177.method_10221(entityType);
            Preconditions.checkState((boolean)class_7923.field_41177.method_10250(id), (String)"Unregistered entity type: %s", (Object)entityType);
            BiomeModifications.create((class_2960)id).add(ModificationPhase.REMOVALS, biomeSelector -> biomeSelector.hasTag(tag), context -> context.getSpawnSettings().removeSpawnsOfEntityType(entityType));
        });
    }

    void addBiomeModification() {
        BiomeModification world = BiomeModifications.create((class_2960)new BloomingNatureIdentifier("world_features"));
        Predicate<BiomeSelectionContext> overworld = BloomingNatureFabric.getBloomingNatureSelector("overworld");
        Predicate<BiomeSelectionContext> plains = BloomingNatureFabric.getBloomingNatureSelector("plains");
        Predicate<BiomeSelectionContext> aspen = BloomingNatureFabric.getBloomingNatureSelector("aspen");
        Predicate<BiomeSelectionContext> birch = BloomingNatureFabric.getBloomingNatureSelector("birch");
        Predicate<BiomeSelectionContext> forest = BloomingNatureFabric.getBloomingNatureSelector("forest");
        Predicate<BiomeSelectionContext> flower_forest = BloomingNatureFabric.getBloomingNatureSelector("flower_forest");
        Predicate<BiomeSelectionContext> river = BloomingNatureFabric.getBloomingNatureSelector("river");
        Predicate<BiomeSelectionContext> cherry_grove = BloomingNatureFabric.getBloomingNatureSelector("cherry_grove");
        Predicate<BiomeSelectionContext> grove = BloomingNatureFabric.getBloomingNatureSelector("grove");
        Predicate<BiomeSelectionContext> snowy_plains = BloomingNatureFabric.getBloomingNatureSelector("snowy_plains");
        Predicate<BiomeSelectionContext> snowy_slopes = BloomingNatureFabric.getBloomingNatureSelector("snowy_slopes");
        Predicate<BiomeSelectionContext> snowy_taiga = BloomingNatureFabric.getBloomingNatureSelector("snowy_taiga");
        Predicate<BiomeSelectionContext> beach = BloomingNatureFabric.getBloomingNatureSelector("beach");
        Predicate<BiomeSelectionContext> stony_shore = BloomingNatureFabric.getBloomingNatureSelector("stony_shore");
        Predicate<BiomeSelectionContext> jungle = BloomingNatureFabric.getBloomingNatureSelector("jungle");
        Predicate<BiomeSelectionContext> sparse_jungle = BloomingNatureFabric.getBloomingNatureSelector("sparse_jungle");
        Predicate<BiomeSelectionContext> desert = BloomingNatureFabric.getBloomingNatureSelector("desert");
        Predicate<BiomeSelectionContext> swamp = BloomingNatureFabric.getBloomingNatureSelector("swamp");
        Predicate<BiomeSelectionContext> dark_forest = BloomingNatureFabric.getBloomingNatureSelector("dark_forest");
        Predicate<BiomeSelectionContext> mangrove_swamp = BloomingNatureFabric.getBloomingNatureSelector("mangrove_swamp");
        Predicate<BiomeSelectionContext> sunflower_plains = BloomingNatureFabric.getBloomingNatureSelector("sunflower_plains");
        Predicate<BiomeSelectionContext> taiga = BloomingNatureFabric.getBloomingNatureSelector("taiga");
        Predicate<BiomeSelectionContext> old_growth_spruce_taiga = BloomingNatureFabric.getBloomingNatureSelector("old_growth_spruce_taiga");
        Predicate<BiomeSelectionContext> old_growth_pine_taiga = BloomingNatureFabric.getBloomingNatureSelector("old_growth_pine_taiga");
        Predicate<BiomeSelectionContext> savanna = BloomingNatureFabric.getBloomingNatureSelector("savanna");
        Predicate<BiomeSelectionContext> savanna_plateau = BloomingNatureFabric.getBloomingNatureSelector("savanna_plateau");
        world.add(ModificationPhase.REMOVALS, overworld, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.LAVA_LAKE_SURFACE));
        world.add(ModificationPhase.REMOVALS, overworld, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.LAVA_LAKE_UNDERGROUND));
        world.add(ModificationPhase.ADDITIONS, beach, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FAN_PALM_TREE_KEY));
        world.add(ModificationPhase.ADDITIONS, beach, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.BEACH_FLOWERS_KEY));
        world.add(ModificationPhase.ADDITIONS, desert, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.QUICKSAND_KEY));
        world.add(ModificationPhase.REMOVALS, plains, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.PLAINS_FLOWERS));
        world.add(ModificationPhase.REMOVALS, plains, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.PLAINS_TREES));
        world.add(ModificationPhase.ADDITIONS, plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PLAINS_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PLAINS_BN_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PLAINS_BN_GRASS));
        world.add(ModificationPhase.ADDITIONS, plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_BOULDER_KEY));
        world.add(ModificationPhase.ADDITIONS, plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_MOUND_KEY));
        world.add(ModificationPhase.ADDITIONS, plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRAVEL_BEACH_KEY));
        world.add(ModificationPhase.ADDITIONS, plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_SLABS_KEY));
        world.add(ModificationPhase.ADDITIONS, plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TRAVERTIN_KEY));
        world.add(ModificationPhase.ADDITIONS, plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PLAINS_BN_MOUND));
        world.add(ModificationPhase.REMOVALS, aspen, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.ASPEN_FLOWERS));
        world.add(ModificationPhase.REMOVALS, aspen, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_DEFAULT));
        world.add(ModificationPhase.REMOVALS, aspen, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.ASPEN_TREES));
        world.add(ModificationPhase.ADDITIONS, aspen, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.ASPEN_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, aspen, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.ASPEN_BN_FALLEN));
        world.add(ModificationPhase.ADDITIONS, aspen, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.ASPEN_BN_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, aspen, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.ASPEN_BN_GRASS));
        world.add(ModificationPhase.ADDITIONS, aspen, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_SLABS_KEY));
        world.add(ModificationPhase.ADDITIONS, aspen, ctx -> ctx.getEffects().setGrassColor(14406505));
        world.add(ModificationPhase.REMOVALS, birch, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.BIRCH_FLOWERS));
        world.add(ModificationPhase.REMOVALS, birch, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_DEFAULT));
        world.add(ModificationPhase.REMOVALS, birch, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.BIRCH_TREES));
        world.add(ModificationPhase.ADDITIONS, birch, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.BIRCH_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, birch, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.BIRCH_BN_FALLEN));
        world.add(ModificationPhase.ADDITIONS, birch, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.BIRCH_BN_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, birch, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.BIRCH_BN_GRASS));
        world.add(ModificationPhase.ADDITIONS, birch, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_SLABS_KEY));
        world.add(ModificationPhase.ADDITIONS, birch, ctx -> ctx.getEffects().setGrassColor(10799444));
        world.add(ModificationPhase.ADDITIONS, birch, ctx -> ctx.getEffects().setFoliageColor(8567370));
        world.add(ModificationPhase.REMOVALS, forest, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.FOREST_FLOWERS));
        world.add(ModificationPhase.REMOVALS, forest, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.FOREST_TREES));
        world.add(ModificationPhase.ADDITIONS, forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FOREST_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FOREST_BN_FALLEN));
        world.add(ModificationPhase.ADDITIONS, forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FOREST_BN_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FOREST_BN_GRASS));
        world.add(ModificationPhase.ADDITIONS, forest, ctx -> ctx.getEffects().setGrassColor(10799444));
        world.add(ModificationPhase.REMOVALS, flower_forest, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_FOREST_FLOWER));
        world.add(ModificationPhase.REMOVALS, flower_forest, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_FOREST_FLOWER_FLOWER));
        world.add(ModificationPhase.REMOVALS, flower_forest, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_FOREST_TREES));
        world.add(ModificationPhase.ADDITIONS, flower_forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_FOREST_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, flower_forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_FOREST_BN_FALLEN));
        world.add(ModificationPhase.ADDITIONS, flower_forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_FOREST_BN_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, flower_forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_FOREST_BN_GRASS));
        world.add(ModificationPhase.ADDITIONS, flower_forest, ctx -> ctx.getEffects().setGrassColor(10799444));
        world.add(ModificationPhase.REMOVALS, river, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.RIVER_TREES));
        world.add(ModificationPhase.REMOVALS, river, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.RIVER_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.RIVER_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PLAINS_BN_GRASS));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_BOULDER_KEY));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_MOUND_KEY));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRAVEL_BEACH_KEY));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_SLABS_KEY));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TRAVERTIN_KEY));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PLAINS_BN_MOUND));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getEffects().setGrassColor(11063154));
        world.add(ModificationPhase.ADDITIONS, river, ctx -> ctx.getEffects().setFoliageColor(10399058));
        world.add(ModificationPhase.REMOVALS, cherry_grove, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.CHERRY_TREES));
        world.add(ModificationPhase.REMOVALS, cherry_grove, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.CHERRY_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, cherry_grove, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.CHERRY_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, cherry_grove, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.CHERRY_BN_FLOWERS));
        world.add(ModificationPhase.REMOVALS, snowy_plains, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.SNOWY_PLAINS_TREES));
        world.add(ModificationPhase.REMOVALS, snowy_plains, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.SNOWY_PLAINS_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, snowy_plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SNOWY_PLAINS_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, snowy_plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_BOULDER_KEY));
        world.add(ModificationPhase.ADDITIONS, snowy_plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_MOUND_KEY));
        world.add(ModificationPhase.ADDITIONS, snowy_plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRAVEL_BEACH_KEY));
        world.add(ModificationPhase.ADDITIONS, snowy_plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_SLABS_KEY));
        world.add(ModificationPhase.ADDITIONS, snowy_slopes, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SNOWY_SLOPES_BN_TREES));
        world.add(ModificationPhase.REMOVALS, snowy_taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.SNOWY_TAIGA_TREES));
        world.add(ModificationPhase.ADDITIONS, snowy_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SNOWY_TAIGA_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, snowy_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_BOULDER_KEY));
        world.add(ModificationPhase.ADDITIONS, snowy_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_MOUND_KEY));
        world.add(ModificationPhase.ADDITIONS, snowy_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRAVEL_BEACH_KEY));
        world.add(ModificationPhase.ADDITIONS, snowy_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_SLABS_KEY));
        world.add(ModificationPhase.REMOVALS, swamp, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_TREES));
        world.add(ModificationPhase.REMOVALS, swamp, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_FLOWERS));
        world.add(ModificationPhase.REMOVALS, swamp, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_GRASS));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_WATER_BASIN));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_MARSH_BASIN));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_FLOATING_LEAVES));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_MUD));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_SWAMP_MUD));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_MARSH));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_VEGETATION));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_CATTAILS));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_REED));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_BN_GRASS));
        world.add(ModificationPhase.ADDITIONS, swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_BN_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, mangrove_swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_WATER_BASIN));
        world.add(ModificationPhase.ADDITIONS, mangrove_swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_MARSH_BASIN));
        world.add(ModificationPhase.ADDITIONS, mangrove_swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_FLOATING_LEAVES));
        world.add(ModificationPhase.ADDITIONS, mangrove_swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_MUD));
        world.add(ModificationPhase.ADDITIONS, mangrove_swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_SWAMP_MUD));
        world.add(ModificationPhase.ADDITIONS, mangrove_swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_MARSH));
        world.add(ModificationPhase.ADDITIONS, mangrove_swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_VEGETATION));
        world.add(ModificationPhase.ADDITIONS, mangrove_swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_CATTAILS));
        world.add(ModificationPhase.ADDITIONS, mangrove_swamp, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SWAMP_REED));
        world.add(ModificationPhase.ADDITIONS, sunflower_plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PLAINS_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, sunflower_plains, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.ASPEN_BN_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, stony_shore, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_PILLARS_KEY));
        world.add(ModificationPhase.ADDITIONS, stony_shore, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_CLIFFS_KEY));
        world.add(ModificationPhase.ADDITIONS, stony_shore, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.COBBLESTONE_BEACH_KEY));
        world.add(ModificationPhase.ADDITIONS, stony_shore, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.COBBLESTONE_BEACH_MOSSY_KEY));
        world.add(ModificationPhase.REMOVALS, taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_LARGE_FERN));
        world.add(ModificationPhase.REMOVALS, taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_TREES));
        world.add(ModificationPhase.REMOVALS, taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_FLOWERS));
        world.add(ModificationPhase.REMOVALS, taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_GRASS));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_SPRUCE_TREES));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_SPRUCE_FALLEN));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_GRASS_PATCH));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_BN_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_BOULDER_KEY));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_MOUND_KEY));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRAVEL_BEACH_KEY));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_SLABS_KEY));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TRAVERTIN_KEY));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_FOREST_MOSS));
        world.add(ModificationPhase.ADDITIONS, taiga, ctx -> ctx.getEffects().setGrassColor(11977352));
        world.add(ModificationPhase.REMOVALS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.OLD_GROWTH_SPRUCE_TAIGA_LARGE_FERN));
        world.add(ModificationPhase.REMOVALS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.OLD_GROWTH_SPRUCE_TAIGA_TREES));
        world.add(ModificationPhase.REMOVALS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.OLD_GROWTH_SPRUCE_TAIGA_FLOWERS));
        world.add(ModificationPhase.REMOVALS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.OLD_GROWTH_SPRUCE_TAIGA_GRASS));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.OLD_GROWTH_SPRUCE_TAIGA_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_SPRUCE_FALLEN));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_GRASS_PATCH));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_BN_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_BOULDER_KEY));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_MOUND_KEY));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRAVEL_BEACH_KEY));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_SLABS_KEY));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TRAVERTIN_KEY));
        world.add(ModificationPhase.ADDITIONS, old_growth_spruce_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_FOREST_MOSS));
        world.add(ModificationPhase.REMOVALS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.OLD_GROWTH_PINE_TAIGA_LARGE_FERN));
        world.add(ModificationPhase.REMOVALS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.OLD_GROWTH_PINE_TAIGA_TREES));
        world.add(ModificationPhase.REMOVALS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.OLD_GROWTH_PINE_TAIGA_FLOWERS));
        world.add(ModificationPhase.REMOVALS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.OLD_GROWTH_PINE_TAIGA_GRASS));
        world.add(ModificationPhase.ADDITIONS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.LARCH_TREES));
        world.add(ModificationPhase.ADDITIONS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.LARCH_FALLEN));
        world.add(ModificationPhase.ADDITIONS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.LARCH_FLOWERS));
        world.add(ModificationPhase.ADDITIONS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.LARCH_GRASS_PATCH));
        world.add(ModificationPhase.ADDITIONS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.STONE_SLABS_KEY));
        world.add(ModificationPhase.ADDITIONS, old_growth_pine_taiga, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.TAIGA_FOREST_MOSS));
        world.add(ModificationPhase.ADDITIONS, old_growth_pine_taiga, ctx -> ctx.getEffects().setGrassColor(9286496));
        world.add(ModificationPhase.ADDITIONS, old_growth_pine_taiga, ctx -> ctx.getEffects().setFoliageColor(10399058));
        world.add(ModificationPhase.REMOVALS, savanna, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.TREES_SAVANNA));
        world.add(ModificationPhase.REMOVALS, savanna, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.PATCH_GRASS_SAVANNA));
        world.add(ModificationPhase.REMOVALS, savanna, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.BROWN_MUSHROOM_NORMAL));
        world.add(ModificationPhase.REMOVALS, savanna, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.RED_MUSHROOM_NORMAL));
        world.add(ModificationPhase.REMOVALS, savanna, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_WARM));
        world.add(ModificationPhase.ADDITIONS, savanna, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SAVANNA_TREES));
        world.add(ModificationPhase.ADDITIONS, savanna, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SAVANNA_VEGETATION));
        world.add(ModificationPhase.ADDITIONS, savanna, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SAVANNA_GRASS_PATCH));
        world.add(ModificationPhase.ADDITIONS, savanna, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRANITE_BOULDERS));
        world.add(ModificationPhase.ADDITIONS, savanna, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRANITE_SLABS));
        world.add(ModificationPhase.ADDITIONS, savanna, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PACKED_MUD));
        world.add(ModificationPhase.ADDITIONS, savanna, ctx -> ctx.getEffects().setGrassColor(15259000));
        world.add(ModificationPhase.ADDITIONS, savanna, ctx -> ctx.getEffects().setFoliageColor(10399058));
        world.add(ModificationPhase.REMOVALS, savanna_plateau, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.TREES_SAVANNA));
        world.add(ModificationPhase.REMOVALS, savanna_plateau, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.PATCH_GRASS_SAVANNA));
        world.add(ModificationPhase.REMOVALS, savanna_plateau, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.BROWN_MUSHROOM_NORMAL));
        world.add(ModificationPhase.REMOVALS, savanna_plateau, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.RED_MUSHROOM_NORMAL));
        world.add(ModificationPhase.REMOVALS, savanna_plateau, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOWER_WARM));
        world.add(ModificationPhase.ADDITIONS, savanna_plateau, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SAVANNA_PLATEAU_TREES));
        world.add(ModificationPhase.ADDITIONS, savanna_plateau, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SAVANNA_VEGETATION));
        world.add(ModificationPhase.ADDITIONS, savanna_plateau, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SAVANNA_GRASS_PATCH));
        world.add(ModificationPhase.ADDITIONS, savanna_plateau, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRANITE_BOULDERS));
        world.add(ModificationPhase.ADDITIONS, savanna_plateau, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.GRANITE_SLABS));
        world.add(ModificationPhase.ADDITIONS, savanna_plateau, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PACKED_MUD));
        world.add(ModificationPhase.ADDITIONS, savanna_plateau, ctx -> ctx.getEffects().setGrassColor(15259000));
        world.add(ModificationPhase.REMOVALS, dark_forest, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.DARK_FOREST_VEGETATION));
        world.add(ModificationPhase.ADDITIONS, dark_forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.DARK_FOREST_TREES));
        world.add(ModificationPhase.ADDITIONS, dark_forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.DARK_FOREST_GRASS_PATCH));
        world.add(ModificationPhase.ADDITIONS, dark_forest, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.DARK_FOREST_TREE_FALLEN));
        world.add(ModificationPhase.ADDITIONS, dark_forest, ctx -> ctx.getEffects().setGrassColor(6975545));
        world.add(ModificationPhase.REMOVALS, jungle, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.JUNGLE_FLOWERS));
        world.add(ModificationPhase.REMOVALS, jungle, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.JUNGLE_TREES));
        world.add(ModificationPhase.REMOVALS, jungle, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.JUNGLE_BAMBOO));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOATING_LEAVES_KEY));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SAVANNA_VEGETATION));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.JUNGLE_FLOWERS_KEY));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.JUNGLE_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_BN_GRASS));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_BN_PUDDLE));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_BN_MUD));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_LATERIT_BOULDER));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13176, PlacedFeatures.SPARSE_JUNGLE_ORE_LATERIT));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getEffects().setGrassColor(8970560));
        world.add(ModificationPhase.ADDITIONS, jungle, ctx -> ctx.getEffects().setFoliageColor(6337104));
        world.add(ModificationPhase.REMOVALS, sparse_jungle, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_FLOWERS));
        world.add(ModificationPhase.REMOVALS, sparse_jungle, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_TREES));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.FLOATING_LEAVES_KEY));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SAVANNA_VEGETATION));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.JUNGLE_FLOWERS_KEY));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_BN_TREES));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_BN_GRASS));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_BN_PUDDLE));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_BN_MUD));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SPARSE_JUNGLE_LATERIT_BOULDER));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13176, PlacedFeatures.SPARSE_JUNGLE_ORE_LATERIT));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getEffects().setGrassColor(8970560));
        world.add(ModificationPhase.ADDITIONS, sparse_jungle, ctx -> ctx.getEffects().setFoliageColor(6337104));
    }

    private static Predicate<BiomeSelectionContext> getBloomingNatureSelector(String path) {
        return BiomeSelectors.tag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new BloomingNatureIdentifier(path)));
    }
}

