/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.block;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1614;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import satisfy.bloomingnature.entity.TermiteEntity;
import satisfy.bloomingnature.registry.EntityRegistry;

public class TermiteBlock
extends class_2248 {
    private final class_2248 hostBlock;
    private static final Map<class_2248, class_2248> BLOCK_BY_HOST_BLOCK = Maps.newIdentityHashMap();
    private static final Map<class_2680, class_2680> HOST_TO_INFESTED_STATES = Maps.newIdentityHashMap();
    private static final Map<class_2680, class_2680> INFESTED_TO_HOST_STATES = Maps.newIdentityHashMap();

    public TermiteBlock(class_2248 block, class_4970.class_2251 properties) {
        super(properties.method_36557(block.method_36555() / 2.0f).method_36558(0.75f));
        this.hostBlock = block;
        BLOCK_BY_HOST_BLOCK.put(block, this);
    }

    public class_2248 getHostBlock() {
        return this.hostBlock;
    }

    public static boolean isCompatibleHostBlock(class_2680 blockState) {
        return BLOCK_BY_HOST_BLOCK.containsKey(blockState.method_26204());
    }

    private void spawnInfestation(class_3218 serverLevel, class_2338 blockPos) {
        TermiteEntity termiteEntity = new TermiteEntity((class_1299<? extends class_1614>)((class_1299)EntityRegistry.TERMITE.get()), (class_1937)serverLevel);
        if (termiteEntity != null) {
            termiteEntity.method_5808((double)blockPos.method_10263() + 0.4, blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, 0.0f, 0.0f);
            serverLevel.method_8649((class_1297)termiteEntity);
            termiteEntity.method_5990();
        }
    }

    public void method_9565(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_1799 itemStack, boolean bl) {
        super.method_9565(blockState, serverLevel, blockPos, itemStack, bl);
        if (serverLevel.method_8450().method_8355(class_1928.field_19392) && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)itemStack) == 0 && serverLevel.field_9229.method_43057() < 0.5f) {
            int numTermites = serverLevel.field_9229.method_43048(2) + 3;
            for (int i = 0; i < numTermites; ++i) {
                this.spawnInfestation(serverLevel, blockPos);
            }
        }
    }

    public static class_2680 infestedStateByHost(class_2680 blockState) {
        return TermiteBlock.getNewStateWithProperties(HOST_TO_INFESTED_STATES, blockState, () -> BLOCK_BY_HOST_BLOCK.get(blockState.method_26204()).method_9564());
    }

    public class_2680 hostStateByInfested(class_2680 blockState) {
        return TermiteBlock.getNewStateWithProperties(INFESTED_TO_HOST_STATES, blockState, () -> this.getHostBlock().method_9564());
    }

    private static class_2680 getNewStateWithProperties(Map<class_2680, class_2680> map, class_2680 blockState, Supplier<class_2680> supplier) {
        return map.computeIfAbsent(blockState, blockStatex -> {
            class_2680 blockState2 = (class_2680)supplier.get();
            for (class_2769 property : blockStatex.method_28501()) {
                blockState2 = blockState2.method_28498(property) ? (class_2680)blockState2.method_11657(property, blockStatex.method_11654(property)) : blockState2;
            }
            return blockState2;
        });
    }
}

