/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.sampler;

import com.dfsek.terra.addons.noise.config.DimensionApplicableNoiseSampler;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.constants.NumericConstant;
import com.dfsek.terra.addons.terrascript.parser.lang.constants.StringConstant;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.Function;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.FunctionBuilder;
import com.dfsek.terra.addons.terrascript.sampler.ConstantSamplerFunction;
import com.dfsek.terra.addons.terrascript.sampler.SamplerFunction;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SamplerFunctionBuilder
implements FunctionBuilder<Function<Number>> {
    private final Map<String, DimensionApplicableNoiseSampler> samplers2d = new HashMap<String, DimensionApplicableNoiseSampler>();
    private final Map<String, DimensionApplicableNoiseSampler> samplers3d = new HashMap<String, DimensionApplicableNoiseSampler>();

    public SamplerFunctionBuilder(Map<String, DimensionApplicableNoiseSampler> samplers) {
        samplers.forEach((id, sampler) -> {
            if (sampler.getDimensions() == 2) {
                this.samplers2d.put((String)id, (DimensionApplicableNoiseSampler)sampler);
            } else if (sampler.getDimensions() == 3) {
                this.samplers3d.put((String)id, (DimensionApplicableNoiseSampler)sampler);
            }
        });
    }

    public Function<Number> build(List<Returnable<?>> argumentList, Position position) {
        Returnable<?> arg = argumentList.get(0);
        if (argumentList.size() == 3) {
            if (arg instanceof StringConstant) {
                StringConstant constant = (StringConstant)arg;
                return new ConstantSamplerFunction(Objects.requireNonNull(this.samplers2d.get(constant.getConstant()), "No such 2D noise function " + (String)constant.getConstant()).getSampler(), argumentList.get(1), (Returnable<Number>)new NumericConstant((Number)0, position), argumentList.get(2), true, position);
            }
            return new SamplerFunction(argumentList.get(0), argumentList.get(1), (Returnable<Number>)new NumericConstant((Number)0, position), argumentList.get(2), s -> Objects.requireNonNull(this.samplers2d.get(s.get()), "No such 2D noise function " + (String)s.get()).getSampler(), true, position);
        }
        if (arg instanceof StringConstant) {
            StringConstant constant = (StringConstant)arg;
            return new ConstantSamplerFunction(Objects.requireNonNull(this.samplers3d.get(constant.getConstant()), "No such 3D noise function " + (String)constant.getConstant()).getSampler(), argumentList.get(1), argumentList.get(2), argumentList.get(3), true, position);
        }
        return new SamplerFunction(argumentList.get(0), argumentList.get(1), argumentList.get(2), argumentList.get(3), s -> Objects.requireNonNull(this.samplers3d.get(s.get()), "No such 3D noise function " + (String)s.get()).getSampler(), true, position);
    }

    public int argNumber() {
        return -1;
    }

    public Returnable.ReturnType getArgument(int position) {
        return switch (position) {
            case 0 -> Returnable.ReturnType.STRING;
            case 1, 2, 3 -> Returnable.ReturnType.NUMBER;
            default -> null;
        };
    }
}

