/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.common.block;

import io.github.fabricators_of_create.porting_lib.tool.ToolActions;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1778;
import net.minecraft.class_1786;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1874;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;
import umpaz.nethersdelight.common.block.entity.AbstractStoveBlockEntity;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.MathUtils;

public abstract class AbstractStoveBlock
extends class_2237 {
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2753 FACING = class_2741.field_12481;

    public AbstractStoveBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if ((Boolean)state.method_11654((class_2769)LIT) != false ? this.tryToExtinguish(state, level, pos, player, hand, hit) : this.tryToIgnite(state, level, pos, player, hand, hit)) {
            return class_1269.method_29236((boolean)level.method_8608());
        }
        if (this.tryToPlaceFoodItem(state, level, pos, player, hand, hit)) {
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    protected boolean tryToIgnite(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldStack = player.method_5998(hand);
        class_1792 heldItem = heldStack.method_7909();
        if (heldStack.canPerformAction(ToolActions.SHOVEL_DIG)) {
            this.extinguish((class_1297)player, state, level, pos);
            heldStack.method_7956(1, (class_1309)player, action -> action.method_20236(hand));
            return true;
        }
        if (heldItem == class_1802.field_8705) {
            if (!level.method_8608()) {
                level.method_8396(null, pos, class_3417.field_15222, class_3419.field_15245, 1.0f, 1.0f);
            }
            this.extinguish((class_1297)player, state, level, pos);
            if (!player.method_31549().field_7477) {
                player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550));
            }
            return true;
        }
        return false;
    }

    protected boolean tryToExtinguish(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldStack = player.method_5998(hand);
        class_1792 heldItem = heldStack.method_7909();
        if (heldItem instanceof class_1786) {
            level.method_8396(player, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
            this.ignite(state, level, pos);
            heldStack.method_7956(1, (class_1309)player, action -> action.method_20236(hand));
            return true;
        }
        if (heldItem instanceof class_1778) {
            if (!level.field_9236) {
                level.method_8396(null, pos, class_3417.field_15013, class_3419.field_15245, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
            }
            this.ignite(state, level, pos);
            if (!player.method_31549().field_7477) {
                heldStack.method_7934(1);
            }
            return true;
        }
        return false;
    }

    protected boolean tryToPlaceFoodItem(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof AbstractStoveBlockEntity)) {
            return false;
        }
        AbstractStoveBlockEntity stoveBlockEntity = (AbstractStoveBlockEntity)blockEntity;
        class_1799 itemstack = player.method_5998(hand);
        Optional recipe = stoveBlockEntity.getCookableRecipe(itemstack);
        if (recipe.isEmpty()) {
            return false;
        }
        if (level.method_8608()) {
            return true;
        }
        return stoveBlockEntity.placeFood((class_1297)player, player.method_31549().field_7477 ? itemstack.method_7972() : itemstack, ((class_1874)recipe.get()).method_8167());
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void method_9591(class_1937 level, class_2338 pos, class_2680 state, class_1297 entity) {
        boolean isLit = (Boolean)level.method_8320(pos).method_11654((class_2769)LIT);
        if (isLit && !entity.method_5753() && entity instanceof class_1309 && !class_1890.method_8216((class_1309)((class_1309)entity))) {
            entity.method_5643(ModDamageTypes.getSimpleDamageSource((class_1937)level, (class_5321)ModDamageTypes.STOVE_BURN), 1.0f);
        }
        super.method_9591(level, pos, state, entity);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        class_2586 tileEntity = level.method_8321(pos);
        if (tileEntity instanceof AbstractStoveBlockEntity) {
            AbstractStoveBlockEntity stoveBlockEntity = (AbstractStoveBlockEntity)tileEntity;
            class_1264.method_17349((class_1937)level, (class_2338)pos, stoveBlockEntity.getItems());
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 p_48722_, class_2470 rotation) {
        return (class_2680)p_48722_.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)p_48722_.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        super.method_9515(stateBuilder);
        stateBuilder.method_11667(new class_2769[]{FACING, LIT});
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 randomSource) {
        if (((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            double x = (double)pos.method_10263() + 0.5;
            double y = pos.method_10264();
            double z = (double)pos.method_10260() + 0.5;
            if (randomSource.method_43048(10) == 0) {
                level.method_8486(x, y, z, (class_3414)ModSounds.BLOCK_STOVE_CRACKLE.get(), class_3419.field_15245, 1.0f, 1.0f, false);
            }
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
            class_2350.class_2351 direction$axis = direction.method_10166();
            double horizontalOffset = randomSource.method_43058() * 0.6 - 0.3;
            double xOffset = direction$axis == class_2350.class_2351.field_11048 ? (double)direction.method_10148() * 0.52 : horizontalOffset;
            double yOffset = randomSource.method_43058() * 6.0 / 16.0;
            double zOffset = direction$axis == class_2350.class_2351.field_11051 ? (double)direction.method_10165() * 0.52 : horizontalOffset;
            level.method_8406((class_2394)class_2398.field_11251, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            level.method_8406((class_2394)class_2398.field_11240, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public void extinguish(@Nullable class_1297 entity, class_2680 state, class_1937 level, class_2338 pos) {
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)), 2);
        double x = (double)pos.method_10263() + 0.5;
        double y = pos.method_10264();
        double z = (double)pos.method_10260() + 0.5;
        level.method_8486(x, y, z, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f, false);
        class_2586 blockentity = level.method_8321(pos);
        if (blockentity instanceof AbstractStoveBlockEntity) {
            AbstractStoveBlockEntity stoveBlockEntity = (AbstractStoveBlockEntity)blockentity;
            stoveBlockEntity.extinguish();
        }
        level.method_33596(entity, class_5712.field_28733, pos);
    }

    public void ignite(class_2680 state, class_1937 level, class_2338 pos) {
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true)), 11);
    }

    @Nullable
    protected static <T extends class_2586> class_5558<T> createStoveTicker(class_1937 level, class_2680 state, class_2591<T> tickerBlockEntityType, class_2591<? extends AbstractStoveBlockEntity<?, ?>> thisBlockEntityType) {
        if (level.field_9236) {
            return AbstractStoveBlock.method_31618(tickerBlockEntityType, thisBlockEntityType, AbstractStoveBlockEntity::particleTick);
        }
        return AbstractStoveBlock.method_31618(tickerBlockEntityType, thisBlockEntityType, (class_5558)((Boolean)state.method_11654((class_2769)LIT) != false ? AbstractStoveBlockEntity::cookTick : AbstractStoveBlockEntity::cooldownTick));
    }

    @Nullable
    public class_7 getBlockPathType(class_2680 state, class_1922 world, class_2338 pos, @Nullable class_1308 entity) {
        return (Boolean)state.method_11654((class_2769)LIT) != false ? class_7.field_3 : null;
    }
}

